/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.pane.impl.async;

import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.content.item.impl.async.LoadingGUIItem;
import de.placeblock.betterinventories.content.pane.impl.simple.BaseSimpleGUIPane;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAsyncGUIPane<T, S extends BaseAsyncGUIPane<T, S>>
extends BaseSimpleGUIPane<GUISection, S> {
    private final GUIItem loadingGUIItem;
    private final Consumer<T> onComplete;

    protected BaseAsyncGUIPane(GUI gui, Vector2d minSize, Vector2d maxSize, boolean autoSize, CompletableFuture<T> task, @Nullable Consumer<T> onComplete, GUIItem loadingGUIItem) {
        super(gui, minSize, maxSize, autoSize);
        this.onComplete = onComplete;
        this.loadingGUIItem = loadingGUIItem;
        int x = (this.getWidth() - 1) / 2;
        int y = (this.getHeight() - 1) / 2;
        this.setSectionAt(new Vector2d(x, y), this.loadingGUIItem);
        task.thenAccept(this::taskComplete);
    }

    private void taskComplete(T data) {
        this.removeSection(this.loadingGUIItem);
        this.onTaskComplete(data);
    }

    protected void onTaskComplete(T data) {
        if (this.onComplete != null) {
            this.onComplete.accept(data);
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, P, T>, P extends BaseAsyncGUIPane<T, P>, T>
    extends BaseSimpleGUIPane.AbstractBuilder<B, P, GUISection> {
        private GUIItem loadingGUIItem;
        private final CompletableFuture<T> task;
        private Consumer<T> onComplete;

        protected AbstractBuilder(GUI gui, CompletableFuture<T> task) {
            super(gui);
            this.loadingGUIItem = new LoadingGUIItem.Builder(gui).build();
            this.task = task;
        }

        public B onComplete(Consumer<T> onComplete) {
            this.onComplete = onComplete;
            return (B)((AbstractBuilder)this.self());
        }

        public B loadingItem(GUIItem loadingGUIItem) {
            this.loadingGUIItem = loadingGUIItem;
            return (B)((AbstractBuilder)this.self());
        }

        @Generated
        protected GUIItem getLoadingGUIItem() {
            return this.loadingGUIItem;
        }

        @Generated
        protected CompletableFuture<T> getTask() {
            return this.task;
        }

        @Generated
        protected Consumer<T> getOnComplete() {
            return this.onComplete;
        }
    }
}

