/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.item.impl.togglebutton;

import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.content.item.GUIButton;
import de.placeblock.betterinventories.content.item.impl.togglebutton.ToggleConsumer;
import de.placeblock.betterinventories.gui.GUI;
import java.util.function.Supplier;
import lombok.Generated;
import org.bukkit.Sound;
import org.bukkit.inventory.ItemStack;

public class ToggleGUIButton
extends GUIButton {
    private boolean toggled;
    private final Supplier<ItemStack> enabledItem;
    private final Supplier<ItemStack> disabledItem;
    private final ToggleConsumer onToggle;

    protected ToggleGUIButton(GUI gui, int cooldown, Sound sound, String permission, boolean toggled, Supplier<ItemStack> enabledItem, Supplier<ItemStack> disabledItem, ToggleConsumer onToggle) {
        super(gui, null, cooldown, sound, permission);
        this.toggled = toggled;
        this.enabledItem = enabledItem;
        this.disabledItem = disabledItem;
        this.onToggle = onToggle;
        this.updateItem();
    }

    @Override
    public void onClick(ClickData data) {
        this.toggle(data);
    }

    public void toggle(ClickData clickData) {
        this.toggled = !this.toggled;
        this.onToggle(clickData, this.toggled);
        this.updateItem();
    }

    private void updateItem() {
        this.setItemStack(this.toggled ? this.getEnabledItem() : this.getDisabledItem());
    }

    protected ItemStack getEnabledItem() {
        if (this.enabledItem == null) {
            throw new IllegalStateException("ToggleGUIButton without enabled item supplier");
        }
        return this.enabledItem.get();
    }

    protected ItemStack getDisabledItem() {
        if (this.disabledItem == null) {
            throw new IllegalStateException("ToggleGUIButton without disabled item supplier");
        }
        return this.disabledItem.get();
    }

    protected void onToggle(ClickData clickData, boolean toggled) {
        if (this.onToggle != null) {
            this.onToggle.apply(clickData, toggled);
        }
    }

    @Generated
    public boolean isToggled() {
        return this.toggled;
    }

    @Generated
    public ToggleConsumer getOnToggle() {
        return this.onToggle;
    }

    public static class Builder
    extends AbstractBuilder<Builder, ToggleGUIButton> {
        public Builder(GUI gui) {
            super(gui);
        }

        @Override
        public ToggleGUIButton build() {
            if (this.getEnabledItem() == null || this.getDisabledItem() == null) {
                throw new IllegalStateException("Enabled and Disabled items have to be set");
            }
            return new ToggleGUIButton(this.getGui(), this.getCooldown(), this.getSound(), this.getPermission(), this.isToggled(), this.getEnabledItem(), this.getDisabledItem(), this.getOnToggle());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, P>, P extends ToggleGUIButton>
    extends GUIButton.AbstractBuilder<B, P> {
        private boolean toggled;
        private ToggleConsumer onToggle;
        private Supplier<ItemStack> enabledItem;
        private Supplier<ItemStack> disabledItem;

        protected AbstractBuilder(GUI gui) {
            super(gui);
        }

        public B toggled(boolean toggled) {
            this.toggled = toggled;
            return (B)((AbstractBuilder)this.self());
        }

        public B onToggle(ToggleConsumer onToggle) {
            this.onToggle = onToggle;
            return (B)((AbstractBuilder)this.self());
        }

        public B enabledItem(Supplier<ItemStack> enabledItem) {
            this.enabledItem = enabledItem;
            return (B)((AbstractBuilder)this.self());
        }

        public B disabledItem(Supplier<ItemStack> disabledItem) {
            this.disabledItem = disabledItem;
            return (B)((AbstractBuilder)this.self());
        }

        @Generated
        protected boolean isToggled() {
            return this.toggled;
        }

        @Generated
        protected ToggleConsumer getOnToggle() {
            return this.onToggle;
        }

        @Generated
        protected Supplier<ItemStack> getEnabledItem() {
            return this.enabledItem;
        }

        @Generated
        protected Supplier<ItemStack> getDisabledItem() {
            return this.disabledItem;
        }
    }
}

