/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.item.impl.cyclebutton;

import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.content.item.GUIButton;
import de.placeblock.betterinventories.content.item.impl.cyclebutton.CycleConsumer;
import de.placeblock.betterinventories.content.item.impl.cyclebutton.CycleEnum;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.ItemBuilder;
import java.util.List;
import lombok.Generated;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CycleGUIButton<E extends CycleEnum>
extends GUIButton {
    private final List<E> values;
    private E currentValue;
    private final CycleConsumer<E> onCycle;

    public CycleGUIButton(GUI gui, int cooldown, Sound sound, E[] values, E startValue, CycleConsumer<E> onCycle) {
        super(gui, null, cooldown, sound, null);
        this.values = List.of(values);
        this.currentValue = startValue;
        this.onCycle = onCycle;
        this.updateItem();
    }

    protected ItemStack getItem(E value) {
        return new ItemBuilder(value.getTitle(), value.getMaterial()).lore(value.getLore()).build();
    }

    @Override
    public void onClick(ClickData data) {
        this.cycle(data);
    }

    public void cycle(ClickData data) {
        this.currentValue = this.getNextValue(data.player(), this.currentValue, this.getNextValue(this.currentValue));
        this.updateItem();
        this.getGui().update();
        this.onCycle(data, this.currentValue);
    }

    private E getNextValue(Player player, E startValue, E nextValue) {
        if (nextValue == startValue) {
            return startValue;
        }
        String permission = nextValue.getPermission();
        if (permission == null || player.hasPermission(permission)) {
            return nextValue;
        }
        return this.getNextValue(player, startValue, this.getNextValue(nextValue));
    }

    private E getNextValue(E currentValue) {
        int currentIndex = this.values.indexOf(currentValue);
        int newIndex = ++currentIndex % this.values.size();
        return (E)((CycleEnum)this.values.get(newIndex));
    }

    private void updateItem() {
        this.setItemStack(this.getItem(this.currentValue));
    }

    protected void onCycle(ClickData data, E newValue) {
        if (this.onCycle != null) {
            this.onCycle.apply(data, newValue);
        }
    }

    @Generated
    public E getCurrentValue() {
        return this.currentValue;
    }

    public static class Builder<E extends CycleEnum>
    extends GUIButton.AbstractBuilder<Builder<E>, CycleGUIButton<E>> {
        private final E[] values;
        private E startValue;
        private CycleConsumer<E> onCycle;

        public Builder(GUI gui, E[] values) {
            super(gui);
            this.values = values;
        }

        public Builder<E> startValue(E startValue) {
            this.startValue = startValue;
            return this;
        }

        public Builder<E> onCycle(CycleConsumer<E> callback) {
            this.onCycle = callback;
            return this;
        }

        @Override
        public CycleGUIButton<E> build() {
            return new CycleGUIButton(this.getGui(), this.getCooldown(), this.getSound(), this.values, this.startValue, this.onCycle);
        }

        @Override
        protected Builder<E> self() {
            return this;
        }
    }
}

