/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.item.impl;

import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.content.item.GUIButton;
import de.placeblock.betterinventories.gui.GUI;
import java.util.function.Function;
import lombok.Generated;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SwitchGUIButton
extends GUIButton {
    private final Function<Player, GUI> targetGUI;

    protected SwitchGUIButton(GUI gui, ItemStack item, int cooldown, Sound sound, String permission, Function<Player, GUI> targetGUI) {
        super(gui, item, cooldown, sound, permission);
        this.targetGUI = targetGUI;
    }

    @Override
    public void onClick(ClickData data) {
        if (this.targetGUI != null) {
            Player player = data.player();
            this.targetGUI.apply(player).showPlayer(player);
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder, SwitchGUIButton> {
        public Builder(GUI gui) {
            super(gui);
        }

        @Override
        public SwitchGUIButton build() {
            return new SwitchGUIButton(this.getGui(), this.getItemStack(), this.getCooldown(), this.getSound(), this.getPermission(), this.getTargetGUI());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B, P>, P extends SwitchGUIButton>
    extends GUIButton.AbstractBuilder<B, P> {
        private Function<Player, GUI> targetGUI;

        protected AbstractBuilder(GUI gui) {
            super(gui);
        }

        public B targetGUI(Function<Player, GUI> target) {
            this.targetGUI = target;
            return (B)((AbstractBuilder)this.self());
        }

        @Generated
        protected Function<Player, GUI> getTargetGUI() {
            return this.targetGUI;
        }
    }
}

