/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content;

import de.placeblock.betterinventories.Builder;
import de.placeblock.betterinventories.Sizeable;
import de.placeblock.betterinventories.content.SearchData;
import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.Util;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.bukkit.inventory.ItemStack;

public abstract class GUISection
implements Sizeable {
    private final GUI gui;
    private Vector2d size;
    protected Vector2d minSize;
    protected Vector2d maxSize;

    protected GUISection(GUI gui, Vector2d size, Vector2d minSize, Vector2d maxSize) {
        this.gui = gui;
        this.size = size;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public void setSize(Vector2d vector2d) {
        this.size = vector2d;
    }

    public abstract List<ItemStack> render();

    public abstract void search(SearchData var1);

    public Vector2d slotToVector(int slot) {
        if (this.getSlots() == 0) {
            return null;
        }
        return Util.slotToVector(slot, this.size.getX());
    }

    public <T> List<T> getEmptyContentList(Class<T> clazz) {
        return new ArrayList<Object>(Collections.nCopies(this.getSlots(), null));
    }

    public int vectorToSlot(Vector2d position) {
        return Util.vectorToSlot(position, this.size.getX());
    }

    public int getSlots() {
        return this.size.getX() * this.size.getY();
    }

    public int getHeight() {
        return this.size.getY();
    }

    public int getWidth() {
        return this.size.getX();
    }

    public abstract void onItemClick(ClickData var1);

    public abstract boolean onItemAdd(Vector2d var1, ItemStack var2);

    public abstract ItemStack onItemRemove(Vector2d var1);

    public abstract ItemStack onItemRemoveTroughInventoryClose(Vector2d var1);

    public abstract boolean onItemAmount(Vector2d var1, int var2);

    @Generated
    public GUI getGui() {
        return this.gui;
    }

    @Override
    @Generated
    public Vector2d getSize() {
        return this.size;
    }

    @Override
    @Generated
    public Vector2d getMinSize() {
        return this.minSize;
    }

    @Override
    @Generated
    public Vector2d getMaxSize() {
        return this.maxSize;
    }

    @Generated
    public void setMinSize(Vector2d minSize) {
        this.minSize = minSize;
    }

    @Generated
    public void setMaxSize(Vector2d maxSize) {
        this.maxSize = maxSize;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, P>, P extends GUISection>
    extends Builder<B, P> {
        private final GUI gui;
        private Vector2d size;
        private Vector2d minSize;
        private Vector2d maxSize;

        public B adoptMinMax(Sizeable sizeable) {
            this.minSize = sizeable.getMinSize();
            this.maxSize = sizeable.getMaxSize();
            return (B)((AbstractBuilder)this.self());
        }

        public B size(Vector2d size) {
            this.size = size;
            return (B)((AbstractBuilder)this.self());
        }

        public B size(int x, int y) {
            return this.size(new Vector2d(x, y));
        }

        public B minSize(Vector2d minSize) {
            this.minSize = minSize;
            return (B)((AbstractBuilder)this.self());
        }

        public B minSize(int x, int y) {
            return this.minSize(new Vector2d(x, y));
        }

        public B maxSize(Vector2d maxSize) {
            this.maxSize = maxSize;
            return (B)((AbstractBuilder)this.self());
        }

        public B maxSize(int x, int y) {
            return this.maxSize(new Vector2d(x, y));
        }

        protected Vector2d getMinSize() {
            if (this.minSize == null) {
                if (this.size == null) {
                    throw new IllegalStateException("minSize and size null");
                }
                return this.size;
            }
            return this.minSize;
        }

        protected Vector2d getMaxSize() {
            if (this.maxSize == null) {
                if (this.size == null) {
                    throw new IllegalStateException("maxSize and size null");
                }
                return this.size;
            }
            return this.maxSize;
        }

        @Generated
        protected GUI getGui() {
            return this.gui;
        }

        @Generated
        protected Vector2d getSize() {
            return this.size;
        }

        @Generated
        public AbstractBuilder(GUI gui) {
            this.gui = gui;
        }
    }
}

