/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.gui.listener;

import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.content.SearchData;
import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.content.pane.GUIPane;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.gui.GUIView;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public record GUIItemListener(GUI gui) implements Listener
{
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        GUIView view = this.gui.getView(event.getInventory());
        if (view == null) {
            return;
        }
        if (event.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
            event.setCancelled(true);
            return;
        }
        view = this.gui.getView(event.getClickedInventory());
        if (view == null) {
            if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                ItemStack offerItem = Objects.requireNonNull(event.getCurrentItem()).clone();
                this.gui.provideItem(offerItem);
                if (offerItem.getAmount() != event.getCurrentItem().getAmount()) {
                    event.getCurrentItem().setAmount(offerItem.getAmount());
                }
                event.setCancelled(true);
            }
            return;
        }
        int slot = event.getSlot();
        this.emitClickEvent(event, player);
        SearchData searchData = new SearchData(slot, s -> s instanceof GUIPane);
        this.gui.searchSection(searchData);
        if (searchData.getSection() == null) {
            event.setCancelled(true);
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        Vector2d pos = searchData.getRelativePos();
        GUISection section = searchData.getSection();
        switch (event.getAction()) {
            case PICKUP_HALF: {
                assert (currentItem != null);
                if (currentItem.getAmount() == 1) {
                    this.dispatchRemove((Cancellable)event, section, pos);
                    break;
                }
                int newAmount = currentItem.getAmount() / 2;
                this.dispatchAmount((Cancellable)event, section, pos, newAmount);
                break;
            }
            case PICKUP_ONE: 
            case DROP_ONE_SLOT: {
                assert (currentItem != null);
                if (currentItem.getAmount() == 1) {
                    this.dispatchRemove((Cancellable)event, section, pos);
                    break;
                }
                this.dispatchAmount((Cancellable)event, section, pos, currentItem.getAmount() - 1);
                break;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                Inventory bottomInventory = event.getView().getBottomInventory();
                if (bottomInventory.firstEmpty() != -1) {
                    this.dispatchRemove((Cancellable)event, section, pos);
                    return;
                }
                assert (currentItem != null);
                int availible = 0;
                for (ItemStack item : bottomInventory.getContents()) {
                    if (!currentItem.isSimilar(item)) continue;
                    assert (item != null);
                    availible += 64 - item.getAmount();
                }
                if (availible == 0) {
                    return;
                }
                if (currentItem.getAmount() > availible) {
                    this.dispatchAmount((Cancellable)event, section, pos, currentItem.getAmount() - availible);
                    break;
                }
                this.dispatchRemove((Cancellable)event, section, pos);
                break;
            }
            case PICKUP_ALL: 
            case DROP_ALL_SLOT: {
                this.dispatchRemove((Cancellable)event, section, pos);
                break;
            }
            case PLACE_ALL: {
                if (currentItem == null) {
                    int newAmount = event.getCursor().getAmount();
                    this.dispatchAdd((Cancellable)event, section, pos, event.getCursor(), newAmount);
                    break;
                }
                int newAmount = currentItem.getAmount() + event.getCursor().getAmount();
                this.dispatchAmount((Cancellable)event, section, pos, newAmount);
                break;
            }
            case PLACE_ONE: {
                if (currentItem == null) {
                    this.dispatchAdd((Cancellable)event, section, pos, event.getCursor(), 1);
                    break;
                }
                this.dispatchAmount((Cancellable)event, section, pos, currentItem.getAmount() + 1);
                break;
            }
            case HOTBAR_SWAP: {
                if (currentItem == null) {
                    ItemStack hotbarItem = this.getHotbarItem(event);
                    this.dispatchAdd((Cancellable)event, section, pos, hotbarItem, hotbarItem.getAmount());
                    break;
                }
                this.dispatchRemove((Cancellable)event, section, pos);
                break;
            }
            case SWAP_WITH_CURSOR: {
                this.dispatchRemove((Cancellable)event, section, pos);
                this.dispatchAdd((Cancellable)event, section, pos, event.getCursor(), event.getCursor().getAmount());
                break;
            }
            case HOTBAR_MOVE_AND_READD: {
                ItemStack hotbarItem = this.getHotbarItem(event);
                if (hotbarItem.isSimilar(currentItem)) {
                    this.dispatchAmount((Cancellable)event, section, pos, hotbarItem.getAmount());
                    break;
                }
                this.dispatchRemove((Cancellable)event, section, pos);
                this.dispatchAdd((Cancellable)event, section, pos, hotbarItem, hotbarItem.getAmount());
                break;
            }
            default: {
                event.setCancelled(true);
            }
        }
    }

    private void emitClickEvent(InventoryClickEvent event, Player player) {
        if (event.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        SearchData searchData = new SearchData(event.getSlot(), s -> true);
        this.gui.searchSection(searchData);
        if (searchData.getSection() == null) {
            return;
        }
        Vector2d pos = searchData.getRelativePos();
        ClickData clickData = new ClickData(player, pos, event.getAction(), event);
        searchData.getSection().onItemClick(clickData);
    }

    private ItemStack getHotbarItem(InventoryClickEvent event) {
        Inventory bottomInventory = event.getView().getBottomInventory();
        return bottomInventory.getItem(event.getHotbarButton());
    }

    private void dispatchAdd(Cancellable event, GUISection section, Vector2d position, ItemStack item, int amount) {
        item = item.clone();
        item.setAmount(amount);
        if (section.onItemAdd(position, item)) {
            event.setCancelled(true);
        }
    }

    public void dispatchRemove(Cancellable event, GUISection section, Vector2d position) {
        ItemStack removedItemStack = section.onItemRemove(position);
        if (removedItemStack == null) {
            event.setCancelled(true);
        }
    }

    private void dispatchAmount(Cancellable event, GUISection section, Vector2d position, int amount) {
        if (section.onItemAmount(position, amount)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        GUIView view = this.gui.getView(event.getInventory());
        if (view == null) {
            return;
        }
        List<Integer> guiSlots = event.getRawSlots().stream().filter(s -> s < this.gui.getSlots()).toList();
        Map<SearchData, Integer> sectionSlots = this.getSections(guiSlots);
        Map<Integer, ItemStack> cancelledSlots = this.getCancelledSlots(event, sectionSlots);
        this.returnToCursor(event, cancelledSlots);
        this.removeItems(view, cancelledSlots);
    }

    private void removeItems(GUIView view, Map<Integer, ItemStack> cancelledSlots) {
        Bukkit.getScheduler().runTaskLater(this.gui.getPlugin(), () -> {
            for (Integer slot : cancelledSlots.keySet()) {
                ItemStack item = view.inventory().getItem(slot.intValue());
                if (item == null) continue;
                int amount = ((ItemStack)cancelledSlots.get(slot)).getAmount();
                item.setAmount(item.getAmount() - amount);
            }
        }, 1L);
    }

    private void returnToCursor(InventoryDragEvent event, Map<Integer, ItemStack> cancelledSlots) {
        ItemStack cursor = event.getCursor();
        for (Integer slot : cancelledSlots.keySet()) {
            ItemStack itemStack = cancelledSlots.get(slot);
            if (cursor != null) {
                cursor.setAmount(cursor.getAmount() + itemStack.getAmount());
                continue;
            }
            cursor = itemStack.clone();
        }
        event.setCursor(cursor);
    }

    private Map<Integer, ItemStack> getCancelledSlots(InventoryDragEvent event, Map<SearchData, Integer> sectionSlots) {
        HashMap<Integer, ItemStack> removedItems = new HashMap<Integer, ItemStack>();
        for (SearchData searchData : sectionSlots.keySet()) {
            GUISection section = searchData.getSection();
            int slot = sectionSlots.get(searchData);
            ItemStack newItem = ((ItemStack)event.getNewItems().get(slot)).clone();
            ItemStack existingItem = event.getView().getItem(slot);
            if (existingItem == null) {
                if (!section.onItemAdd(searchData.getRelativePos(), newItem)) continue;
                removedItems.put(slot, newItem);
                continue;
            }
            if (!section.onItemAmount(searchData.getRelativePos(), newItem.getAmount())) continue;
            newItem.setAmount(newItem.getAmount() - existingItem.getAmount());
            removedItems.put(slot, newItem);
        }
        return removedItems;
    }

    private Map<SearchData, Integer> getSections(List<Integer> guiSlots) {
        HashMap<SearchData, Integer> sectionSlots = new HashMap<SearchData, Integer>();
        for (Integer guiSlot : guiSlots) {
            SearchData searchData = new SearchData(guiSlot, s -> s instanceof GUIPane);
            this.gui.searchSection(searchData);
            sectionSlots.put(searchData, guiSlot);
        }
        return sectionSlots;
    }
}

