/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.gui.impl;

import de.placeblock.betterinventories.Sizeable;
import de.placeblock.betterinventories.content.pane.GUIPane;
import de.placeblock.betterinventories.gui.impl.BaseCanvasGUI;
import de.placeblock.betterinventories.util.Vector2d;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BaseChestGUI<C extends GUIPane>
extends BaseCanvasGUI<C>
implements Sizeable {
    private int maxHeight;
    private int minHeight;

    protected BaseChestGUI(Plugin plugin, TextComponent title, boolean removeItems, int minHeight, int maxHeight) {
        super(plugin, title, InventoryType.CHEST, removeItems);
        this.maxHeight = maxHeight;
        this.minHeight = minHeight;
    }

    @Override
    public void update() {
        Vector2d oldSize = this.canvas.getSize();
        this.canvas.updateSizeRecursive(this);
        Vector2d newSize = this.canvas.getSize();
        if (!oldSize.equals(newSize)) {
            this.reloadViews();
        }
        super.update();
    }

    @Override
    public Vector2d getMaxSize() {
        return new Vector2d(9, this.maxHeight);
    }

    @Override
    public Vector2d getMinSize() {
        return new Vector2d(9, this.minHeight);
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, G, C, P>, G extends BaseChestGUI<C>, C extends GUIPane, P extends JavaPlugin>
    extends BaseCanvasGUI.AbstractBuilder<B, G, C, P> {
        private int minHeight;
        private int maxHeight;

        public AbstractBuilder(P plugin) {
            super(plugin);
        }

        public B minHeight(int minHeight) {
            this.minHeight = minHeight;
            return (B)((AbstractBuilder)this.self());
        }

        public B maxHeight(int maxHeight) {
            this.maxHeight = maxHeight;
            return (B)((AbstractBuilder)this.self());
        }

        protected int getMinHeight() {
            return this.minHeight;
        }

        protected int getMaxHeight() {
            return this.maxHeight;
        }
    }
}

