/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.gui;

import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.content.SearchData;
import de.placeblock.betterinventories.content.pane.GUIPane;
import de.placeblock.betterinventories.gui.GUIView;
import de.placeblock.betterinventories.gui.listener.GUIItemListener;
import de.placeblock.betterinventories.gui.listener.GUIListener;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class GUI {
    private final Plugin plugin;
    private TextComponent title;
    private final List<GUIView> views = new ArrayList<GUIView>();
    private final InventoryType type;
    private List<ItemStack> content = new ArrayList<ItemStack>();
    private final GUIListener guiListener;
    private final GUIItemListener itemListener;
    private final boolean removeItems;

    protected GUI(Plugin plugin, TextComponent title, InventoryType type, boolean removeItems) {
        this.plugin = plugin;
        this.type = type;
        this.title = title;
        this.guiListener = new GUIListener(this);
        this.itemListener = new GUIItemListener(this);
        this.removeItems = removeItems;
    }

    public abstract Inventory createBukkitInventory();

    public GUIView showPlayer(Player player) {
        if (this.views.size() == 0) {
            PluginManager pluginManager = this.plugin.getServer().getPluginManager();
            pluginManager.registerEvents((Listener)this.guiListener, this.plugin);
            pluginManager.registerEvents((Listener)this.itemListener, this.plugin);
        }
        if (this.getPlayers().contains(player)) {
            return null;
        }
        GUIView view = new GUIView(player, this.createBukkitInventory());
        view.update(this.content);
        this.views.add(view);
        return view;
    }

    public List<Player> getPlayers() {
        return this.views.stream().map(GUIView::player).toList();
    }

    public GUIView getView(Inventory inventory) {
        for (GUIView view : this.views) {
            if (!view.inventory().equals(inventory)) continue;
            return view;
        }
        return null;
    }

    public GUIView getView(Player player) {
        for (GUIView view : this.views) {
            if (!view.player().equals(player)) continue;
            return view;
        }
        return null;
    }

    public abstract int getSlots();

    protected abstract List<ItemStack> renderContent();

    public abstract void searchSection(SearchData var1);

    public abstract void provideItem(ItemStack var1);

    public void update() {
        this.render();
        this.updateViews();
    }

    private void render() {
        this.content = this.renderContent();
    }

    private void updateViews() {
        for (GUIView view : this.views) {
            view.update(this.content);
        }
    }

    protected void reloadViews() {
        List<Player> players = this.getPlayers();
        ArrayList<GUIView> views = new ArrayList<GUIView>(this.getViews());
        for (GUIView view : views) {
            this.removePlayer(view);
        }
        for (Player player : players) {
            this.showPlayer(player);
        }
    }

    public void updateTitle(TextComponent title) {
        this.title = title;
        this.reloadViews();
    }

    public void removePlayer(GUIView view) {
        Player player = view.player();
        if (this.removeItems) {
            for (int i = 0; i < this.getSlots(); ++i) {
                Vector2d pos;
                ItemStack removedItemStack;
                SearchData searchData = new SearchData(i, s -> s instanceof GUIPane);
                this.searchSection(searchData);
                GUISection section = searchData.getSection();
                if (section == null || (removedItemStack = section.onItemRemove(pos = searchData.getRelativePos())) == null) continue;
                player.getInventory().addItem(new ItemStack[]{removedItemStack});
            }
        }
        this.views.remove(view);
        this.onClose(player);
        if (this.views.size() == 0) {
            HandlerList.unregisterAll((Listener)this.guiListener);
            HandlerList.unregisterAll((Listener)this.itemListener);
        }
    }

    public void onClose(Player player) {
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public TextComponent getTitle() {
        return this.title;
    }

    public List<GUIView> getViews() {
        return this.views;
    }

    public InventoryType getType() {
        return this.type;
    }

    public List<ItemStack> getContent() {
        return this.content;
    }

    public GUIListener getGuiListener() {
        return this.guiListener;
    }

    public GUIItemListener getItemListener() {
        return this.itemListener;
    }

    public boolean isRemoveItems() {
        return this.removeItems;
    }

    public static abstract class Builder<B extends Builder<B, G, P>, G extends GUI, P extends JavaPlugin>
    extends de.placeblock.betterinventories.Builder<B, G> {
        private final P plugin;
        private TextComponent title;
        private InventoryType type;
        private boolean removeItems = true;

        public B title(TextComponent title) {
            this.title = title;
            return (B)((Builder)this.self());
        }

        public B removeItems(boolean removeItems) {
            this.removeItems = removeItems;
            return (B)((Builder)this.self());
        }

        public B type(InventoryType type) {
            this.type = type;
            return (B)((Builder)this.self());
        }

        public Builder(P plugin) {
            this.plugin = plugin;
        }

        protected P getPlugin() {
            return this.plugin;
        }

        protected TextComponent getTitle() {
            return this.title;
        }

        protected InventoryType getType() {
            return this.type;
        }

        protected boolean isRemoveItems() {
            return this.removeItems;
        }
    }
}

