/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.pane.impl.io;

import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.content.pane.impl.simple.BaseSimpleItemGUIPane;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.function.BiConsumer;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public abstract class BaseIOGUIPane<S extends BaseIOGUIPane<S>>
extends BaseSimpleItemGUIPane<S> {
    private final boolean input;
    private final boolean output;

    protected BaseIOGUIPane(GUI gui, Vector2d minSize, Vector2d maxSize, boolean autoSize, boolean input, boolean output) {
        super(gui, minSize, maxSize, autoSize);
        this.input = input;
        this.output = output;
    }

    @Override
    public boolean onItemAdd(Vector2d position, ItemStack itemStack) {
        if (!this.input) {
            return false;
        }
        this.setSectionAt(position, ((GUIItem.Builder)new GUIItem.Builder(this.getGui()).itemStack(itemStack)).build());
        Bukkit.getScheduler().runTaskLater(this.getGui().getPlugin(), () -> {
            this.onItemChange(position, itemStack);
            this.getGui().update();
        }, 1L);
        return false;
    }

    @Override
    public ItemStack onItemRemove(Vector2d position) {
        if (!this.output) {
            return null;
        }
        GUIItem item = this.getItem(position);
        boolean removed = this.removeSection(item);
        if (removed) {
            Bukkit.getScheduler().runTaskLater(this.getGui().getPlugin(), () -> {
                this.onItemChange(position, null);
                this.getGui().update();
            }, 1L);
            return item.getItemStack();
        }
        return null;
    }

    @Override
    public boolean onItemAmount(Vector2d position, int amount) {
        GUIItem item = this.getItem(position);
        int oldAmount = item.getItemStack().getAmount();
        if (oldAmount < amount && !this.input || oldAmount > amount && !this.output) {
            return false;
        }
        item.getItemStack().setAmount(amount);
        Bukkit.getScheduler().runTaskLater(this.getGui().getPlugin(), () -> {
            this.onItemChange(position, item.getItemStack());
            this.getGui().update();
        }, 1L);
        return false;
    }

    @Override
    public void onItemProvide(ItemStack itemStack) {
        if (!this.input) {
            return;
        }
        ItemStack itemClone = itemStack.clone();
        for (int slot = 0; slot < this.getSlots() && itemStack.getAmount() > 0; ++slot) {
            int accepted;
            Vector2d position = this.slotToVector(slot);
            GUIItem item = this.getItem(position);
            if (item != null) {
                ItemStack currentItemStack = item.getItemStack();
                int currentAmount = currentItemStack.getAmount();
                int maxStackSize = currentItemStack.getMaxStackSize();
                if (!currentItemStack.isSimilar(itemStack) || currentAmount >= maxStackSize) continue;
                accepted = Math.min(maxStackSize - currentAmount, itemStack.getAmount());
                currentItemStack.setAmount(accepted + currentAmount);
                this.onItemChange(position, currentItemStack);
            } else {
                accepted = Math.min(itemStack.getMaxStackSize(), itemStack.getAmount());
                ItemStack slotItem = itemClone.clone();
                slotItem.setAmount(accepted);
                this.setSectionAt(slot, ((GUIItem.Builder)new GUIItem.Builder(this.getGui()).itemStack(slotItem)).build());
                this.onItemChange(position, slotItem);
            }
            itemStack.setAmount(itemStack.getAmount() - accepted);
        }
        Bukkit.getScheduler().runTaskLater(this.getGui().getPlugin(), () -> this.getGui().update(), 1L);
    }

    public abstract void onItemChange(Vector2d var1, ItemStack var2);

    public static abstract class Builder<B extends Builder<B, P>, P extends BaseIOGUIPane<P>>
    extends BaseSimpleItemGUIPane.AbstractBuilder<B, P> {
        private boolean input = true;
        private boolean output = true;
        private BiConsumer<Vector2d, ItemStack> onChange = (p, i) -> {};

        public Builder(GUI gui) {
            super(gui);
        }

        public B input(boolean input) {
            this.input = input;
            return (B)((Builder)this.self());
        }

        public B output(boolean output) {
            this.output = output;
            return (B)((Builder)this.self());
        }

        public B onChange(BiConsumer<Vector2d, ItemStack> onChange) {
            this.onChange = onChange;
            return (B)((Builder)this.self());
        }

        protected boolean isInput() {
            return this.input;
        }

        protected boolean isOutput() {
            return this.output;
        }

        protected BiConsumer<Vector2d, ItemStack> getOnChange() {
            return this.onChange;
        }
    }
}

