/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.pane.impl;

import de.placeblock.betterinventories.Sizeable;
import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.content.SearchData;
import de.placeblock.betterinventories.content.pane.GUIPane;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public abstract class BaseHorizontalSplitGUIPane
extends GUIPane {
    private GUIPane upperPane;
    private GUIPane lowerPane;

    protected BaseHorizontalSplitGUIPane(GUI gui, Vector2d minSize, Vector2d maxSize, GUIPane upperPane, GUIPane lowerPane) {
        super(gui, minSize, maxSize);
        this.upperPane = upperPane;
        this.lowerPane = lowerPane;
    }

    @Override
    public void updateSizeRecursive(Sizeable parent) {
        if (this.upperPane != null) {
            this.upperPane.updateSizeRecursive(parent);
        }
        if (this.lowerPane != null) {
            this.lowerPane.updateSizeRecursive(parent);
        }
        this.updateSize(parent);
    }

    @Override
    public void updateSize(Sizeable parent) {
        int width = this.getNewWidth();
        int height = this.getNewHeight();
        Vector2d newSize = new Vector2d(width, height);
        this.setSize(Vector2d.min(this.maxSize, newSize));
    }

    private int getNewWidth() {
        return Math.max(this.upperPane == null ? 0 : this.upperPane.getWidth(), this.lowerPane == null ? 0 : this.lowerPane.getWidth());
    }

    private int getNewHeight() {
        return (this.upperPane == null ? 0 : this.upperPane.getHeight()) + (this.lowerPane == null ? 0 : this.lowerPane.getHeight());
    }

    @Override
    public List<GUISection> getChildren() {
        ArrayList<GUISection> children = new ArrayList<GUISection>();
        if (this.upperPane != null) {
            children.add(this.upperPane);
        }
        if (this.lowerPane != null) {
            children.add(this.lowerPane);
        }
        return children;
    }

    @Override
    public void onItemProvide(ItemStack item) {
    }

    @Override
    public List<ItemStack> render() {
        List<ItemStack> content = this.getEmptyContentList(ItemStack.class);
        if (!content.isEmpty()) {
            if (this.upperPane != null) {
                this.renderOnList(this.upperPane, new Vector2d(), content);
            }
            if (this.lowerPane != null) {
                this.renderOnList(this.lowerPane, this.getLowerPanePos(), content);
            }
        }
        return content;
    }

    public Vector2d getLowerPanePos() {
        if (this.upperPane == null) {
            return new Vector2d();
        }
        return new Vector2d(0, this.upperPane.getHeight());
    }

    @Override
    public void search(SearchData searchData) {
        Vector2d relativePos = searchData.getRelativePos();
        if (this.upperPane == null) {
            if (this.lowerPane == null || !searchData.getPredicate().test(this.lowerPane)) {
                searchData.setSection(this);
                return;
            }
            searchData.addNode(this);
            searchData.setRelativePos(relativePos.subtract(this.getLowerPanePos()));
            this.lowerPane.search(searchData);
        } else if ((this.lowerPane == null || relativePos.getY() < this.upperPane.getHeight()) && searchData.getPredicate().test(this.upperPane)) {
            searchData.addNode(this);
            this.upperPane.search(searchData);
        } else if (searchData.getPredicate().test(this.lowerPane)) {
            searchData.addNode(this);
            searchData.setRelativePos(relativePos.subtract(this.getLowerPanePos()));
            this.lowerPane.search(searchData);
        } else {
            searchData.setSection(this);
        }
    }

    public void setUpperPane(GUIPane upperPane) {
        this.upperPane = upperPane;
    }

    public void setLowerPane(GUIPane lowerPane) {
        this.lowerPane = lowerPane;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B, P>, P extends BaseHorizontalSplitGUIPane>
    extends GUIPane.AbstractBuilder<B, P> {
        private GUIPane upperPane;
        private GUIPane lowerPane;

        protected AbstractBuilder(GUI gui) {
            super(gui);
        }

        public B upperPane(GUIPane upperPane) {
            this.upperPane = upperPane;
            return (B)((AbstractBuilder)this.self());
        }

        public B lowerPane(GUIPane lowerPane) {
            this.lowerPane = lowerPane;
            return (B)((AbstractBuilder)this.self());
        }

        protected GUIPane getUpperPane() {
            return this.upperPane;
        }

        protected GUIPane getLowerPane() {
            return this.lowerPane;
        }
    }
}

