/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.item.impl;

import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.content.item.GUIButton;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.ItemBuilder;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.inventory.ItemStack;

public class SubmitGUIButton
extends GUIButton {
    public static final ItemStack SUBMIT_ITEM = new ItemBuilder(Component.text((String)"Best\u00e4tigen"), Material.GREEN_DYE).build();
    private final ItemStack submitItem;
    private final ItemStack item;
    private boolean submitPhase = false;
    private boolean delayTimerRunning = false;
    private final int submitDelay;
    private final Consumer<ClickData> onSubmit;

    protected SubmitGUIButton(GUI gui, ItemStack item, int cooldown, Sound sound, String permission, ItemStack submitItem, int submitDelay, Consumer<ClickData> onSubmit) {
        super(gui, item, cooldown, sound, permission);
        this.item = item;
        this.submitItem = submitItem == null ? SUBMIT_ITEM : submitItem;
        this.submitDelay = submitDelay;
        this.onSubmit = onSubmit;
    }

    @Override
    public void onClick(ClickData data) {
        if (this.submitPhase) {
            this.onSubmit(data);
        } else if (!this.delayTimerRunning) {
            if (this.submitDelay == 0) {
                this.startSubmitPhase();
            } else {
                this.delayTimerRunning = true;
                Bukkit.getScheduler().runTaskLater(this.getGui().getPlugin(), this::startSubmitPhase, (long)this.submitDelay);
            }
        }
    }

    private void startSubmitPhase() {
        this.setItemStack(this.submitItem);
        this.delayTimerRunning = false;
        this.submitPhase = true;
        Bukkit.getScheduler().runTaskLater(this.getGui().getPlugin(), this::endSubmitPhase, 100L);
    }

    private void endSubmitPhase() {
        this.setItemStack(this.item);
        this.submitPhase = false;
    }

    public void onSubmit(ClickData data) {
        if (this.onSubmit != null) {
            this.onSubmit.accept(data);
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder, SubmitGUIButton> {
        public Builder(GUI gui) {
            super(gui);
        }

        @Override
        public SubmitGUIButton build() {
            return new SubmitGUIButton(this.getGui(), this.getItemStack(), this.getCooldown(), this.getSound(), this.getPermission(), this.getSubmitItem(), this.getSubmitDelay(), this.getOnSubmit());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B, P>, P extends SubmitGUIButton>
    extends GUIButton.AbstractBuilder<B, P> {
        private ItemStack submitItem = new ItemBuilder(Component.text((String)"Submit"), Material.LIME_DYE).build();
        private int submitDelay;
        private Consumer<ClickData> onSubmit;

        protected AbstractBuilder(GUI gui) {
            super(gui);
        }

        public B submitItem(ItemStack item) {
            this.submitItem = item;
            return (B)((AbstractBuilder)this.self());
        }

        public B submitDelay(int submitDelay) {
            this.submitDelay = submitDelay;
            return (B)((AbstractBuilder)this.self());
        }

        public B onSubmit(Consumer<ClickData> onSubmit) {
            this.onSubmit = onSubmit;
            return (B)((AbstractBuilder)this.self());
        }

        protected ItemStack getSubmitItem() {
            return this.submitItem;
        }

        protected int getSubmitDelay() {
            return this.submitDelay;
        }

        protected Consumer<ClickData> getOnSubmit() {
            return this.onSubmit;
        }
    }
}

