/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.item;

import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.gui.GUIView;
import java.util.function.Consumer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class GUIButton
extends GUIItem {
    private final int cooldown;
    private final Sound clickSound;
    private final String permission;
    private final Consumer<ClickData> onClick;
    private final Consumer<ClickData> onShiftClick;
    private final Consumer<ClickData> onLeftClick;
    private final Consumer<ClickData> onRightClick;
    private final Consumer<ClickData> onShiftRightClick;
    private final Consumer<ClickData> onShiftLeftClick;

    protected GUIButton(GUI gui, ItemStack item, int cooldown, Sound clickSound, String permission, Consumer<ClickData> onClick, Consumer<ClickData> onShiftClick, Consumer<ClickData> onLeftClick, Consumer<ClickData> onRightClick, Consumer<ClickData> onShiftLeftClick, Consumer<ClickData> onShiftRightClick) {
        super(gui, item);
        this.cooldown = cooldown;
        this.clickSound = clickSound;
        this.permission = permission;
        this.onClick = onClick;
        this.onShiftClick = onShiftClick;
        this.onLeftClick = onLeftClick;
        this.onRightClick = onRightClick;
        this.onShiftRightClick = onShiftRightClick;
        this.onShiftLeftClick = onShiftLeftClick;
    }

    protected GUIButton(GUI gui, ItemStack item, int cooldown, Sound clickSound, String permission) {
        this(gui, item, cooldown, clickSound, permission, null, null, null, null, null, null);
    }

    public boolean hasPermission(Player player) {
        return this.permission == null || player.hasPermission(this.permission);
    }

    public void click(Player player) {
        if (this.cooldown > 0) {
            this.applyCooldown();
        }
        if (this.clickSound != null) {
            player.playSound(player.getEyeLocation(), this.clickSound, 0.8f, 1.0f);
        }
    }

    public void applyCooldown() {
        this.setCooldown(this.cooldown);
    }

    public void setCooldown(int cooldown) {
        for (GUIView view : this.getGui().getViews()) {
            view.player().setCooldown(this.itemStack.getType(), cooldown);
        }
    }

    public void onClick(ClickData data) {
        if (this.onClick != null) {
            this.onClick.accept(data);
        }
    }

    public void onLeftClick(ClickData data) {
        if (this.onLeftClick != null) {
            this.onLeftClick.accept(data);
        }
    }

    public void onRightClick(ClickData data) {
        if (this.onRightClick != null) {
            this.onRightClick.accept(data);
        }
    }

    public void onShiftClick(ClickData data) {
        if (this.onShiftClick != null) {
            this.onShiftClick.accept(data);
        }
    }

    public void onShiftLeftClick(ClickData data) {
        if (this.onShiftLeftClick != null) {
            this.onShiftLeftClick.accept(data);
        }
    }

    public void onShiftRightClick(ClickData data) {
        if (this.onShiftRightClick != null) {
            this.onShiftRightClick.accept(data);
        }
    }

    @Override
    public void onItemClick(ClickData data) {
        InventoryClickEvent event = data.event();
        boolean leftClick = event.isLeftClick();
        boolean rightClick = event.isRightClick();
        boolean shiftClick = event.isShiftClick();
        this.click(data.player());
        this.onClick(data);
        if (leftClick) {
            if (shiftClick) {
                this.onShiftLeftClick(data);
            } else {
                this.onLeftClick(data);
            }
        } else if (rightClick) {
            if (shiftClick) {
                this.onShiftRightClick(data);
            } else {
                this.onRightClick(data);
            }
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder, GUIButton> {
        public Builder(GUI gui) {
            super(gui);
        }

        @Override
        public GUIButton build() {
            return new GUIButton(this.getGui(), this.getItemStack(), this.getCooldown(), this.getSound(), this.getPermission(), this.getOnClick(), this.getOnShiftClick(), this.getOnLeftClick(), this.getOnRightClick(), this.getOnShiftLeftClick(), this.getOnShiftRightClick());
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B, P>, P extends GUIButton>
    extends GUIItem.AbstractBuilder<B, P> {
        private String permission;
        private int cooldown = 0;
        private Sound sound = Sound.UI_BUTTON_CLICK;
        private Consumer<ClickData> onClick;
        private Consumer<ClickData> onShiftClick;
        private Consumer<ClickData> onLeftClick;
        private Consumer<ClickData> onRightClick;
        private Consumer<ClickData> onShiftRightClick;
        private Consumer<ClickData> onShiftLeftClick;

        protected AbstractBuilder(GUI gui) {
            super(gui);
        }

        public B permission(String permission) {
            this.permission = permission;
            return (B)((AbstractBuilder)this.self());
        }

        public B cooldown(int cooldown) {
            this.cooldown = cooldown;
            return (B)((AbstractBuilder)this.self());
        }

        public B sound(Sound sound) {
            this.sound = sound;
            return (B)((AbstractBuilder)this.self());
        }

        public B onClick(Consumer<ClickData> callback) {
            this.onClick = callback;
            return (B)((AbstractBuilder)this.self());
        }

        public B onShiftClick(Consumer<ClickData> onShiftClick) {
            this.onShiftClick = onShiftClick;
            return (B)((AbstractBuilder)this.self());
        }

        public B onRightClick(Consumer<ClickData> onRightClick) {
            this.onRightClick = onRightClick;
            return (B)((AbstractBuilder)this.self());
        }

        public B onLeftClick(Consumer<ClickData> onLeftClick) {
            this.onLeftClick = onLeftClick;
            return (B)((AbstractBuilder)this.self());
        }

        public B onShiftRightClick(Consumer<ClickData> onShiftRightClick) {
            this.onShiftRightClick = onShiftRightClick;
            return (B)((AbstractBuilder)this.self());
        }

        public B onShiftLeftClick(Consumer<ClickData> onShiftLeftClick) {
            this.onShiftLeftClick = onShiftLeftClick;
            return (B)((AbstractBuilder)this.self());
        }

        protected String getPermission() {
            return this.permission;
        }

        protected int getCooldown() {
            return this.cooldown;
        }

        protected Sound getSound() {
            return this.sound;
        }

        protected Consumer<ClickData> getOnClick() {
            return this.onClick;
        }

        protected Consumer<ClickData> getOnShiftClick() {
            return this.onShiftClick;
        }

        protected Consumer<ClickData> getOnLeftClick() {
            return this.onLeftClick;
        }

        protected Consumer<ClickData> getOnRightClick() {
            return this.onRightClick;
        }

        protected Consumer<ClickData> getOnShiftRightClick() {
            return this.onShiftRightClick;
        }

        protected Consumer<ClickData> getOnShiftLeftClick() {
            return this.onShiftLeftClick;
        }
    }
}

