/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.gui.impl.textinput;

import de.placeblock.betterinventories.gui.impl.textinput.TextInputGUI;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class TextInputPacketListener {
    private final TextInputGUI gui;
    private Channel channel;

    public void inject() {
        Player player = this.gui.getPlayer();
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        this.channel = serverPlayer.connection.connection.channel;
        this.channel.pipeline().addAfter("decoder", "textInputPacketListener", (ChannelHandler)new MessageToMessageDecoder<Packet>(){

            protected void decode(ChannelHandlerContext ctx, Packet msg, List<Object> out) {
                out.add(msg);
                if (msg instanceof ServerboundRenameItemPacket) {
                    ServerboundRenameItemPacket packet = (ServerboundRenameItemPacket)msg;
                    TextInputPacketListener.this.gui.updateText(packet.getName());
                }
            }
        });
    }

    public void uninject() {
        this.channel.pipeline().remove("textInputPacketListener");
    }

    public TextInputPacketListener(TextInputGUI gui) {
        this.gui = gui;
    }
}

