/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.pane.impl.paginator;

import de.placeblock.betterinventories.Sizeable;
import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.content.pane.impl.BaseHorizontalSplitGUIPane;
import de.placeblock.betterinventories.content.pane.impl.paginator.ItemAddable;
import de.placeblock.betterinventories.content.pane.impl.paginator.PaginatorContentPane;
import de.placeblock.betterinventories.content.pane.impl.paginator.PaginatorControlsPane;
import de.placeblock.betterinventories.content.pane.impl.paginator.PaginatorControlsPosition;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.Util;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class PaginatorGUIPane
extends BaseHorizontalSplitGUIPane
implements ItemAddable<PaginatorGUIPane> {
    private final List<GUIItem> items;
    private PaginatorControlsPane defaultControls;
    private final PaginatorContentPane contentPane;
    private int currentPage;
    private boolean repeat;

    @Deprecated
    public PaginatorGUIPane(GUI gui, Vector2d minSize, Vector2d maxSize, boolean repeat, int startPage, Function<PaginatorGUIPane, PaginatorControlsPane> defaultControls, List<GUIItem> items) {
        super(gui, minSize, maxSize, null, null);
        this.items = items;
        this.contentPane = new PaginatorContentPane(gui, minSize, maxSize, this);
        this.setUpperPane(this.contentPane);
        this.currentPage = startPage;
        this.repeat = repeat;
        if (defaultControls != null) {
            this.defaultControls = defaultControls.apply(this);
        }
        this.contentPane.setItems();
    }

    @Deprecated(forRemoval=true)
    public PaginatorGUIPane(GUI gui, Vector2d minSize, Vector2d maxSize, boolean repeat, int startPage, PaginatorControlsPosition defaultControlsPosition, List<GUIItem> items) {
        this(gui, minSize, maxSize, repeat, startPage, (PaginatorGUIPane p) -> null, items);
        this.defaultControls = ((PaginatorControlsPane.Builder)((PaginatorControlsPane.Builder)new PaginatorControlsPane.Builder(gui, this).minSize(minSize.getX(), 1)).maxSize(maxSize.getX(), 1)).position(defaultControlsPosition).build();
    }

    @Override
    public void updateSize(Sizeable parent) {
        int newWidth = Math.max(Math.min(parent.getMaxSize().getX(), this.items.size()), 2);
        int itemHeight = (int)Math.ceil((float)this.items.size() * 1.0f / (float)newWidth);
        int realHeight = Math.min(parent.getMaxSize().getY(), itemHeight);
        this.setSize(new Vector2d(newWidth, realHeight));
        this.currentPage = Math.min(this.currentPage, this.getPages());
        if (this.showDefaultControls()) {
            this.setLowerPane(this.defaultControls);
        } else {
            this.setLowerPane(null);
        }
    }

    @Override
    public void updateSizeRecursive(Sizeable parent) {
        this.updateSize(parent);
        this.contentPane.updateSizeRecursive(parent);
        if (this.defaultControls != null) {
            this.defaultControls.updateSizeRecursive(parent);
        }
    }

    public <I extends GUIItem> PaginatorGUIPane setItems(List<I> items) {
        this.items.clear();
        this.items.addAll(items);
        this.contentPane.setItems();
        return this;
    }

    @Override
    public void onItemAdd() {
        this.contentPane.setItems();
    }

    public PaginatorGUIPane clearItems() {
        this.items.clear();
        this.contentPane.setItems();
        return this;
    }

    public PaginatorGUIPane nextPage() {
        this.setCurrentPage(this.getNextPage());
        return this;
    }

    private int getNextPage() {
        int pages = this.getPages();
        if (this.currentPage + 1 > pages && !this.repeat) {
            return this.currentPage;
        }
        return (this.currentPage + 1) % pages;
    }

    public PaginatorGUIPane previousPage() {
        this.setCurrentPage(this.getPreviousPage());
        return this;
    }

    private int getPreviousPage() {
        if (this.currentPage == 0 && !this.repeat) {
            return 0;
        }
        return Util.modulo(this.currentPage - 1, this.getPages());
    }

    public PaginatorGUIPane setCurrentPage(int index) {
        this.currentPage = index;
        this.contentPane.setItems();
        return this;
    }

    public int getPages() {
        return (int)Math.ceil((float)this.items.size() * 1.0f / (float)this.contentPane.getSlots());
    }

    public Vector2d getContentPaneSize() {
        int height = this.showDefaultControls() ? this.getHeight() - 1 : this.getHeight();
        return new Vector2d(this.getWidth(), height);
    }

    private boolean showDefaultControls() {
        return this.showDefaultControls(this.items.size(), this.getSlots());
    }

    private boolean showDefaultControls(int itemSize, int slots) {
        return itemSize > slots && this.defaultControls != null;
    }

    @Override
    public List<GUIItem> getItems() {
        return this.items;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public static class Builder
    extends BaseHorizontalSplitGUIPane.Builder<Builder, PaginatorGUIPane>
    implements ItemAddable<Builder> {
        private final List<GUIItem> items = new ArrayList<GUIItem>();
        private boolean repeat = true;
        private int startPage = 0;
        private PaginatorControlsPosition controlsPosition = PaginatorControlsPosition.RIGHT;
        private Function<PaginatorGUIPane, PaginatorControlsPane> controls;

        public Builder(GUI gui) {
            super(gui);
        }

        public Builder repeat(boolean repeat) {
            this.repeat = repeat;
            return this;
        }

        public Builder startPage(int startPage) {
            this.startPage = startPage;
            return this;
        }

        public Builder controls(PaginatorControlsPosition position) {
            this.controlsPosition = position;
            return this;
        }

        public Builder controls(Function<PaginatorGUIPane, PaginatorControlsPane> controls) {
            this.controls = controls;
            return this;
        }

        @Override
        public PaginatorGUIPane build() {
            if (this.controlsPosition != null) {
                return new PaginatorGUIPane(this.getGui(), this.getMinSize(), this.getMaxSize(), this.repeat, this.startPage, this.controlsPosition, this.items);
            }
            return new PaginatorGUIPane(this.getGui(), this.getMinSize(), this.getMaxSize(), this.repeat, this.startPage, this.controls, this.items);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public List<GUIItem> getItems() {
            return this.items;
        }
    }
}

