/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.pane.impl.paginator;

import de.placeblock.betterinventories.Sizeable;
import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.content.item.impl.paginator.NextPageGUIButton;
import de.placeblock.betterinventories.content.item.impl.paginator.PreviousPageGUIButton;
import de.placeblock.betterinventories.content.pane.impl.paginator.PaginatorControlsPosition;
import de.placeblock.betterinventories.content.pane.impl.paginator.PaginatorGUIPane;
import de.placeblock.betterinventories.content.pane.impl.simple.BaseSimpleItemGUIPane;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.ItemBuilder;
import de.placeblock.betterinventories.util.Vector2d;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;

public class PaginatorControlsPane
extends BaseSimpleItemGUIPane<PaginatorControlsPane> {
    public static GUIItem FILL_ITEM = ((GUIItem.Builder)new GUIItem.Builder(null).itemStack(new ItemBuilder(Component.empty(), Material.BLACK_STAINED_GLASS_PANE).build())).build();
    private final PaginatorGUIPane paginatorGUIPane;
    private final NextPageGUIButton nextButton;
    private final PreviousPageGUIButton previousButton;
    private final PaginatorControlsPosition position;
    private boolean autoSize;

    @Deprecated(forRemoval=true)
    public PaginatorControlsPane(GUI gui, PaginatorGUIPane paginatorGUIPane, Vector2d minSize, Vector2d maxSize, boolean autoSize, PaginatorControlsPosition position, NextPageGUIButton nextButton, PreviousPageGUIButton previousButton) {
        super(gui, minSize, maxSize, false);
        this.paginatorGUIPane = paginatorGUIPane;
        this.position = position;
        this.autoSize = autoSize;
        this.nextButton = nextButton;
        this.previousButton = previousButton;
        this.onSizeChange();
    }

    private void updateButtons() {
        this.removeSection(this.nextButton);
        this.removeSection(this.previousButton);
        int[] buttonIndices = this.position.calculateIndices.apply(this.getSize().getX());
        int currentPage = this.paginatorGUIPane.getCurrentPage();
        int pages = this.paginatorGUIPane.getPages();
        boolean repeat = this.paginatorGUIPane.isRepeat();
        this.setSectionAt(buttonIndices[0], currentPage > 0 || repeat ? this.previousButton : FILL_ITEM);
        this.setSectionAt(buttonIndices[1], currentPage < pages - 1 || repeat ? this.nextButton : FILL_ITEM);
    }

    @Override
    public void updateSize(Sizeable parent) {
        if (this.autoSize) {
            this.setSize(new Vector2d(this.paginatorGUIPane.getWidth(), 1));
        }
    }

    @Override
    public void onSizeChange() {
        this.clear();
        this.fill(FILL_ITEM);
        this.updateButtons();
    }

    public void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
    }

    public static class Builder
    extends BaseSimpleItemGUIPane.Builder<Builder, PaginatorControlsPane> {
        private final PaginatorGUIPane paginator;
        private PaginatorControlsPosition position = PaginatorControlsPosition.RIGHT;
        private NextPageGUIButton nextButton;
        private PreviousPageGUIButton previousButton;

        public Builder(GUI gui, PaginatorGUIPane paginator) {
            super(gui);
            this.paginator = paginator;
            this.nextButton = ((NextPageGUIButton.Builder)new NextPageGUIButton.Builder(gui, paginator).itemStack(new ItemBuilder(Component.text((String)"Next Page"), Material.ARROW).build())).build();
            this.previousButton = ((PreviousPageGUIButton.Builder)new PreviousPageGUIButton.Builder(gui, paginator).itemStack(new ItemBuilder(Component.text((String)"Previous Page"), Material.ARROW).build())).build();
        }

        public Builder position(PaginatorControlsPosition position) {
            this.position = position;
            return this;
        }

        public Builder nextButton(NextPageGUIButton nextButton) {
            this.nextButton = nextButton;
            return this;
        }

        public Builder previousButton(PreviousPageGUIButton previousButton) {
            this.previousButton = previousButton;
            return this;
        }

        @Override
        public PaginatorControlsPane build() {
            return new PaginatorControlsPane(this.getGui(), this.paginator, this.getMinSize(), this.getMaxSize(), this.isAutoSize(), this.position, this.nextButton, this.previousButton);
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

