/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.item.impl;

import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.content.item.GUIButton;
import de.placeblock.betterinventories.gui.GUI;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.bukkit.Sound;
import org.bukkit.inventory.ItemStack;

public abstract class ToggleGUIButton
extends GUIButton {
    private boolean toggled;

    public ToggleGUIButton(GUI gui, int cooldown, Sound sound, String permission, boolean toggled) {
        super(gui, null, cooldown, sound, permission);
        this.toggled = toggled;
        this.updateItem();
    }

    @Override
    public void onClick(ClickData data) {
        this.toggle(data);
    }

    public void toggle(ClickData clickData) {
        this.toggled = !this.toggled;
        this.onToggle(clickData, this.toggled);
        this.updateItem();
    }

    private void updateItem() {
        this.setItemStack(this.toggled ? this.getEnabledItem() : this.getDisabledItem());
    }

    protected abstract ItemStack getEnabledItem();

    protected abstract ItemStack getDisabledItem();

    protected abstract void onToggle(ClickData var1, boolean var2);

    public boolean isToggled() {
        return this.toggled;
    }

    public static class Builder
    extends GUIButton.AbstractBuilder<Builder, ToggleGUIButton> {
        private boolean toggled;
        private BiConsumer<ClickData, Boolean> onToggle;
        private Supplier<ItemStack> enabledItem;
        private Supplier<ItemStack> disabledItem;

        public Builder(GUI gui) {
            super(gui);
        }

        public Builder toggled(boolean toggled) {
            this.toggled = toggled;
            return this;
        }

        public Builder onToggle(BiConsumer<ClickData, Boolean> onToggle) {
            this.onToggle = onToggle;
            return this;
        }

        public Builder enabledItem(Supplier<ItemStack> enabledItem) {
            this.enabledItem = enabledItem;
            return this;
        }

        public Builder disabledItem(Supplier<ItemStack> disabledItem) {
            this.disabledItem = disabledItem;
            return this;
        }

        @Override
        public ToggleGUIButton build() {
            if (this.enabledItem == null || this.disabledItem == null) {
                throw new IllegalStateException("Enabled and Disabled items have to be set");
            }
            return new ToggleGUIButton(this.getGui(), this.getCooldown(), this.getSound(), this.getPermission(), this.toggled){

                @Override
                protected ItemStack getEnabledItem() {
                    return enabledItem.get();
                }

                @Override
                protected ItemStack getDisabledItem() {
                    return disabledItem.get();
                }

                @Override
                protected void onToggle(ClickData clickData, boolean toggled) {
                    onToggle.accept(clickData, toggled);
                }
            };
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

