/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.item;

import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.gui.GUIView;
import java.util.function.Consumer;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class GUIButton
extends GUIItem {
    private final int cooldown;
    private final Sound clickSound;
    private final String permission;

    public GUIButton(GUI gui, ItemStack item, int cooldown, Sound clickSound, String permission) {
        super(gui, item);
        this.cooldown = cooldown;
        this.clickSound = clickSound;
        this.permission = permission;
    }

    public boolean hasPermission(Player player) {
        return this.permission == null || player.hasPermission(this.permission);
    }

    public void click(Player player) {
        if (this.cooldown > 0) {
            this.applyCooldown();
        }
        if (this.clickSound != null) {
            player.playSound(player.getEyeLocation(), this.clickSound, 0.8f, 1.0f);
        }
    }

    public void applyCooldown() {
        this.setCooldown(this.cooldown);
    }

    public void setCooldown(int cooldown) {
        for (GUIView view : this.getGui().getViews()) {
            view.getPlayer().setCooldown(this.itemStack.getType(), cooldown);
        }
    }

    public abstract void onClick(ClickData var1);

    public void onLeftClick(ClickData data) {
    }

    public void onRightClick(ClickData data) {
    }

    public void onShiftClick(ClickData data) {
        this.onClick(data);
    }

    public void onShiftLeftClick(ClickData data) {
        this.onLeftClick(data);
    }

    public void onShiftRightClick(ClickData data) {
        this.onRightClick(data);
    }

    @Override
    public void onItemClick(ClickData data) {
        InventoryClickEvent event = data.getEvent();
        boolean leftClick = event.isLeftClick();
        boolean rightClick = event.isRightClick();
        boolean shiftClick = event.isShiftClick();
        this.click(data.getPlayer());
        this.onClick(data);
        if (leftClick) {
            if (shiftClick) {
                this.onShiftLeftClick(data);
            } else {
                this.onLeftClick(data);
            }
        } else if (rightClick) {
            if (shiftClick) {
                this.onShiftRightClick(data);
            } else {
                this.onRightClick(data);
            }
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder, GUIButton> {
        public Builder(GUI gui) {
            super(gui);
        }

        @Override
        public GUIButton build() {
            return new GUIButton(this.getGui(), this.getItemStack(), this.getCooldown(), this.getSound(), this.getPermission()){

                @Override
                public void onClick(ClickData data) {
                    if (this.getOnClick() != null) {
                        this.getOnClick().accept(data);
                    }
                }

                @Override
                public void onShiftClick(ClickData data) {
                    if (this.getOnShiftClick() != null) {
                        this.getOnShiftClick().accept(data);
                    }
                }

                @Override
                public void onRightClick(ClickData data) {
                    if (this.getOnRightClick() != null) {
                        this.getOnRightClick().accept(data);
                    }
                }

                @Override
                public void onLeftClick(ClickData data) {
                    if (this.getOnLeftClick() != null) {
                        this.getOnLeftClick().accept(data);
                    }
                }

                @Override
                public void onShiftRightClick(ClickData data) {
                    if (this.getOnShiftRightClick() != null) {
                        this.getOnShiftRightClick().accept(data);
                    }
                }

                @Override
                public void onShiftLeftClick(ClickData data) {
                    if (this.getOnShiftLeftClick() != null) {
                        this.getOnShiftLeftClick().accept(data);
                    }
                }
            };
        }

        @Override
        protected Builder self() {
            return this;
        }
    }

    protected static abstract class AbstractBuilder<B extends AbstractBuilder<B, P>, P extends GUIButton>
    extends GUIItem.AbstractBuilder<B, P> {
        private String permission;
        private int cooldown = 0;
        private Sound sound = Sound.UI_BUTTON_CLICK;
        private Consumer<ClickData> onClick;
        private Consumer<ClickData> onShiftClick;
        private Consumer<ClickData> onLeftClick;
        private Consumer<ClickData> onRightClick;
        private Consumer<ClickData> onShiftRightClick;
        private Consumer<ClickData> onShiftLeftClick;

        protected AbstractBuilder(GUI gui) {
            super(gui);
        }

        public B permission(String permission) {
            this.permission = permission;
            return (B)((AbstractBuilder)this.self());
        }

        public B cooldown(int cooldown) {
            this.cooldown = cooldown;
            return (B)((AbstractBuilder)this.self());
        }

        public B sound(Sound sound) {
            this.sound = sound;
            return (B)((AbstractBuilder)this.self());
        }

        public B onClick(Consumer<ClickData> callback) {
            this.onClick = callback;
            return (B)((AbstractBuilder)this.self());
        }

        public B onShiftClick(Consumer<ClickData> onShiftClick) {
            this.onShiftClick = onShiftClick;
            return (B)((AbstractBuilder)this.self());
        }

        public B onRightClick(Consumer<ClickData> onRightClick) {
            this.onRightClick = onRightClick;
            return (B)((AbstractBuilder)this.self());
        }

        public B onLeftClick(Consumer<ClickData> onLeftClick) {
            this.onLeftClick = onLeftClick;
            return (B)((AbstractBuilder)this.self());
        }

        public B onShiftRightClick(Consumer<ClickData> onShiftRightClick) {
            this.onShiftRightClick = onShiftRightClick;
            return (B)((AbstractBuilder)this.self());
        }

        public B onShiftLeftClick(Consumer<ClickData> onShiftLeftClick) {
            this.onShiftLeftClick = onShiftLeftClick;
            return (B)((AbstractBuilder)this.self());
        }

        protected String getPermission() {
            return this.permission;
        }

        protected int getCooldown() {
            return this.cooldown;
        }

        protected Sound getSound() {
            return this.sound;
        }

        protected Consumer<ClickData> getOnClick() {
            return this.onClick;
        }

        protected Consumer<ClickData> getOnShiftClick() {
            return this.onShiftClick;
        }

        protected Consumer<ClickData> getOnLeftClick() {
            return this.onLeftClick;
        }

        protected Consumer<ClickData> getOnRightClick() {
            return this.onRightClick;
        }

        protected Consumer<ClickData> getOnShiftRightClick() {
            return this.onShiftRightClick;
        }

        protected Consumer<ClickData> getOnShiftLeftClick() {
            return this.onShiftLeftClick;
        }
    }
}

