/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.gui.impl;

import de.placeblock.betterinventories.Sizeable;
import de.placeblock.betterinventories.content.pane.GUIPane;
import de.placeblock.betterinventories.gui.impl.BaseCanvasGUI;
import de.placeblock.betterinventories.util.Vector2d;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.Plugin;

public abstract class BaseChestGUI<P extends GUIPane>
extends BaseCanvasGUI<P>
implements Sizeable {
    private int maxHeight;
    private int minHeight;

    public BaseChestGUI(Plugin plugin, TextComponent title, int minHeight, int maxHeight) {
        super(plugin, title, InventoryType.CHEST);
        this.maxHeight = maxHeight;
        this.minHeight = minHeight;
    }

    @Override
    public void update() {
        Vector2d oldSize = this.canvas.getSize();
        this.canvas.updateSizeRecursive(this);
        Vector2d newSize = this.canvas.getSize();
        if (!oldSize.equals(newSize)) {
            this.reloadViews();
        }
        super.update();
    }

    @Override
    public Vector2d getMaxSize() {
        return new Vector2d(9, this.maxHeight);
    }

    @Override
    public Vector2d getMinSize() {
        return new Vector2d(9, this.minHeight);
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }
}

