/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.pane.impl.simple;

import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.content.pane.impl.simple.BaseSimpleGUIPane;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.Util;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;

public class SimpleItemGUIPane
extends BaseSimpleGUIPane<GUIItem, SimpleItemGUIPane> {
    public SimpleItemGUIPane(GUI gui, Vector2d minSize, Vector2d maxSize) {
        this(gui, minSize, maxSize, false);
    }

    public SimpleItemGUIPane(GUI gui, Vector2d minSize, Vector2d maxSize, boolean autoSize) {
        super(gui, minSize, maxSize, autoSize);
    }

    public void flipY() {
        this.applyTransformation(v -> {
            int spaceLeft = v.getX() + 1;
            return new Vector2d(this.getWidth() - spaceLeft, v.getY());
        });
    }

    public void flipX() {
        this.applyTransformation(v -> {
            int spaceTop = v.getY() + 1;
            return new Vector2d(v.getX(), this.getHeight() - spaceTop);
        });
    }

    public void shiftX(int delta) {
        this.applyTransformation(v -> {
            if (v.getX() >= 0 && v.getX() < this.getWidth()) {
                int newX = Util.modulo(v.getX() + delta, this.getWidth());
                return new Vector2d(newX, v.getY());
            }
            return v;
        });
    }

    public void shiftY(int delta) {
        this.applyTransformation(v -> {
            if (v.getY() >= 0 && v.getY() < this.getHeight()) {
                int newY = Util.modulo(v.getY() + delta, this.getHeight());
                return new Vector2d(v.getX(), newY);
            }
            return v;
        });
    }

    private void applyTransformation(Function<Vector2d, Vector2d> transformation) {
        for (BaseSimpleGUIPane.ChildData childData : this.content) {
            Vector2d newPos = transformation.apply(childData.getPosition());
            childData.setPosition(newPos);
        }
    }

    public GUIItem getItem(int slot) {
        return this.getItem(this.slotToVector(slot));
    }

    public GUIItem getItem(Vector2d position) {
        Collection sections = this.getSections(position);
        Iterator iterator = sections.iterator();
        if (iterator.hasNext()) {
            GUIItem section = (GUIItem)iterator.next();
            return section;
        }
        return null;
    }
}

