/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.pane.impl.paginator;

import de.placeblock.betterinventories.content.item.GUIItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public interface ItemAddable<O extends ItemAddable<O>> {
    public List<GUIItem> getItems();

    default public O addItem(GUIItem item) {
        this.getItems().add(item);
        this.onItemAdd();
        return (O)this;
    }

    default public O addItems(Collection<GUIItem> items) {
        this.getItems().addAll(items);
        this.onItemAdd();
        return (O)this;
    }

    default public O addItems(GUIItem ... items) {
        return this.addItems(List.of(items));
    }

    default public <T> O addItems(Function<T, GUIItem> converter, Collection<T> items) {
        ArrayList<GUIItem> guiItems = new ArrayList<GUIItem>();
        for (T item : items) {
            guiItems.add(converter.apply(item));
        }
        return this.addItems(guiItems);
    }

    default public <T> O addItems(Function<T, GUIItem> converter, T[] items) {
        return this.addItems(converter, new ArrayList<T>(List.of(items)));
    }

    default public void onItemAdd() {
    }
}

