/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.pane.impl;

import de.placeblock.betterinventories.Sizeable;
import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.content.pane.GUIPane;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.inventory.ItemStack;

public class HorizontalSplitGUIPane
extends GUIPane {
    private GUIPane upperPane;
    private GUIPane lowerPane;

    public HorizontalSplitGUIPane(GUI gui, Vector2d minSize, Vector2d maxSize) {
        super(gui, minSize, maxSize);
    }

    @Override
    public void updateSizeRecursive(Sizeable parent) {
        if (this.upperPane != null) {
            this.upperPane.updateSizeRecursive(parent);
        }
        if (this.lowerPane != null) {
            this.lowerPane.updateSizeRecursive(parent);
        }
        this.updateSize(parent);
    }

    @Override
    public void updateSize(Sizeable parent) {
        int width = this.getNewWidth();
        int height = this.getNewHeight();
        Vector2d newSize = new Vector2d(width, height);
        this.setSize(Vector2d.min(this.maxSize, newSize));
    }

    private int getNewWidth() {
        return Math.max(this.upperPane == null ? 0 : this.upperPane.getWidth(), this.lowerPane == null ? 0 : this.lowerPane.getWidth());
    }

    private int getNewHeight() {
        return (this.upperPane == null ? 0 : this.upperPane.getHeight()) + (this.lowerPane == null ? 0 : this.lowerPane.getHeight());
    }

    @Override
    public Set<GUISection> getChildren() {
        HashSet<GUISection> children = new HashSet<GUISection>();
        if (this.upperPane != null) {
            children.add(this.upperPane);
        }
        if (this.lowerPane != null) {
            children.add(this.lowerPane);
        }
        return children;
    }

    @Override
    public void onItemProvide(ItemStack item) {
    }

    @Override
    public List<ItemStack> render() {
        List<ItemStack> content = this.getEmptyContentList(ItemStack.class);
        if (!content.isEmpty()) {
            if (this.upperPane != null) {
                this.renderOnList(this.upperPane, new Vector2d(), content);
            }
            if (this.lowerPane != null) {
                this.renderOnList(this.lowerPane, this.getLowerPanePos(), content);
            }
        }
        return content;
    }

    public Vector2d getLowerPanePos() {
        if (this.upperPane == null) {
            return new Vector2d();
        }
        return new Vector2d(0, this.upperPane.getHeight());
    }

    @Override
    public GUISection.SearchData search(Vector2d position, boolean onlyPanes) {
        if (this.upperPane == null) {
            if (this.lowerPane == null) {
                return null;
            }
            return this.lowerPane.search(position.subtract(this.getLowerPanePos()), onlyPanes);
        }
        if (this.lowerPane == null || position.getY() < this.upperPane.getHeight()) {
            return this.upperPane.search(position, onlyPanes);
        }
        return this.lowerPane.search(position.subtract(this.getLowerPanePos()), onlyPanes);
    }

    public void setUpperPane(GUIPane upperPane) {
        this.upperPane = upperPane;
    }

    public void setLowerPane(GUIPane lowerPane) {
        this.lowerPane = lowerPane;
    }
}

