/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content;

import de.placeblock.betterinventories.Sizeable;
import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.Util;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public abstract class GUISection
implements Sizeable {
    private final GUI gui;
    private Vector2d size;
    protected Vector2d minSize;
    protected Vector2d maxSize;

    public GUISection(GUI gui, Vector2d size, Vector2d minSize, Vector2d maxSize) {
        this.gui = gui;
        this.size = size;
        this.minSize = minSize;
        this.maxSize = maxSize;
    }

    public void setSize(Vector2d vector2d) {
        this.size = vector2d;
    }

    public abstract List<ItemStack> render();

    public SearchData search(int slot, boolean onlyPanes) {
        return this.search(this.slotToVector(slot), onlyPanes);
    }

    public abstract SearchData search(Vector2d var1, boolean var2);

    public Vector2d slotToVector(int slot) {
        if (this.getSlots() == 0) {
            return null;
        }
        return Util.slotToVector(slot, this.size.getX());
    }

    public <T> List<T> getEmptyContentList(Class<T> clazz) {
        return new ArrayList<Object>(Collections.nCopies(this.getSlots(), null));
    }

    public int vectorToSlot(Vector2d position) {
        return Util.vectorToSlot(position, this.size.getX());
    }

    public int getSlots() {
        return this.size.getX() * this.size.getY();
    }

    public int getHeight() {
        return this.size.getY();
    }

    public int getWidth() {
        return this.size.getX();
    }

    public abstract void onItemClick(ClickData var1);

    public abstract boolean onItemAdd(Vector2d var1, ItemStack var2);

    public abstract boolean onItemRemove(Vector2d var1);

    public abstract boolean onItemAmount(Vector2d var1, int var2);

    public GUI getGui() {
        return this.gui;
    }

    @Override
    public Vector2d getSize() {
        return this.size;
    }

    @Override
    public Vector2d getMinSize() {
        return this.minSize;
    }

    @Override
    public Vector2d getMaxSize() {
        return this.maxSize;
    }

    public static class SearchData {
        private final GUISection section;
        private final Vector2d relativePos;

        public GUISection getSection() {
            return this.section;
        }

        public Vector2d getRelativePos() {
            return this.relativePos;
        }

        public SearchData(GUISection section, Vector2d relativePos) {
            this.section = section;
            this.relativePos = relativePos;
        }
    }
}

