package de.placeblock.betterinventories.content.item;

import de.placeblock.betterinventories.builder.content.GUIItemBuilder;
import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.ItemBuilder;
import de.placeblock.betterinventories.util.Vector2d;
import lombok.Getter;
import lombok.Setter;
import org.bukkit.inventory.ItemStack;

import java.util.ArrayList;
import java.util.List;

/**
 * A {@link GUISection} with a size of 1x1 containing an {@link ItemStack}
 * <br>
 * Builder: {@link GUIItemBuilder}
 */
@Getter
@SuppressWarnings("unused")
public class GUIItem extends GUISection {
    /**
     * The Size of every GUIItem
     */
    public static final Vector2d BUTTON_SIZE = new Vector2d(1, 1);
    /**
     * The ItemStack to be rendered
     */
    @Setter
    protected ItemStack itemStack;

    /**
     * Creates a new GUIItem
     * @param gui The GUI
     * @param itemStack The ItemStack. {@link ItemBuilder} may help to create it.
     */
    public GUIItem(GUI gui, ItemStack itemStack) {
        super(gui, BUTTON_SIZE, BUTTON_SIZE, BUTTON_SIZE);
        this.itemStack = itemStack;
    }

    /**
     * Renders the GUIItem on a list
     * @return The List
     */
    @Override
    public List<ItemStack> render() {
        return new ArrayList<>(List.of(itemStack));
    }

    /**
     * Returns the GUISection at a specific slot.
     * For GUIItems it will always return the GUIItem itself.
     * @param slot The slot
     * @param onlyPanes Whether to return only panes even
     *                  if there is an item at the clicked slot
     * @return The GUISection
     */
    @Override
    public SearchData search(int slot, boolean onlyPanes) {
        if (onlyPanes) {
            throw new IllegalStateException("Cannot search for panes only in item");
        }
        return new SearchData(this, new Vector2d());
    }

    /**
     * Returns the GUISection at a specific position.
     * For GUIItems it will always return the GUIItem itself.
     * @param position The position
     * @param onlyPanes Whether to return only panes even
     *                  if there is an item at the clicked slot
     * @return The GUISection
     */
    @Override
    public SearchData search(Vector2d position, boolean onlyPanes) {
        if (onlyPanes) {
            throw new IllegalStateException("Cannot search for panes only in item");
        }
        return new SearchData(this, position);
    }


    @Override
    public void onItemClick(ClickData data) {}

    @Override
    public boolean onItemAdd(Vector2d position, ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean onItemRemove(Vector2d position) {
        return true;
    }

    @Override
    public boolean onItemAmount(Vector2d position, int amount) {
        return true;
    }
}
