/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.gui;

import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.gui.GUIView;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class GUI
implements Listener {
    private final Plugin plugin;
    private final TextComponent title;
    private final List<GUIView> views = new ArrayList<GUIView>();
    private final InventoryType type;
    private List<ItemStack> content = new ArrayList<ItemStack>();

    public GUI(Plugin plugin, TextComponent title, InventoryType type) {
        this.plugin = plugin;
        this.type = type;
        this.title = title;
    }

    public abstract Inventory createBukkitInventory();

    public GUIView showPlayer(Player player) {
        if (this.views.size() == 0) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        }
        if (this.getPlayers().contains(player)) {
            return null;
        }
        GUIView view = new GUIView(player, this.createBukkitInventory());
        view.update(this.content);
        this.views.add(view);
        return view;
    }

    public List<Player> getPlayers() {
        return this.views.stream().map(GUIView::getPlayer).toList();
    }

    public GUIView getView(Inventory inventory) {
        for (GUIView view : this.views) {
            if (!view.getInventory().equals(inventory)) continue;
            return view;
        }
        return null;
    }

    public GUIView getView(Player player) {
        for (GUIView view : this.views) {
            if (!view.getPlayer().equals(player)) continue;
            return view;
        }
        return null;
    }

    public void reloadViews() {
        List<Player> players = this.getPlayers();
        ArrayList<GUIView> views = new ArrayList<GUIView>(this.getViews());
        for (GUIView view : views) {
            this.removePlayer(view);
        }
        for (Player player : players) {
            this.showPlayer(player);
        }
    }

    public abstract int getSlots();

    public abstract List<ItemStack> renderContent();

    public abstract GUISection.SearchData searchSection(int var1, boolean var2);

    public abstract void provideItem(ItemStack var1);

    public void update() {
        this.render();
        this.updateViews();
    }

    protected void render() {
        this.content = this.renderContent();
    }

    protected void updateViews() {
        for (GUIView view : this.views) {
            view.update(this.content);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        GUIView view = this.getView(event.getInventory());
        if (view == null) {
            return;
        }
        if (event.getAction() == InventoryAction.COLLECT_TO_CURSOR) {
            event.setCancelled(true);
            return;
        }
        view = this.getView(event.getClickedInventory());
        if (view == null) {
            if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                ItemStack offerItem = Objects.requireNonNull(event.getCurrentItem()).clone();
                this.provideItem(offerItem);
                if (offerItem.getAmount() != event.getCurrentItem().getAmount()) {
                    event.getCurrentItem().setAmount(offerItem.getAmount());
                }
                event.setCancelled(true);
            }
            return;
        }
        int slot = event.getSlot();
        GUISection.SearchData searchData = this.searchSection(slot, true);
        if (searchData == null) {
            event.setCancelled(true);
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        Vector2d pos = searchData.getRelativePos();
        GUISection section = searchData.getSection();
        ClickData clickData = new ClickData(player, pos, event.getAction(), event);
        section.onItemClick(clickData);
        switch (event.getAction()) {
            case PICKUP_HALF: {
                assert (currentItem != null);
                if (currentItem.getAmount() == 1) {
                    this.dispatchRemove((Cancellable)event, section, pos);
                    break;
                }
                int newAmount = currentItem.getAmount() / 2;
                this.dispatchAmount((Cancellable)event, section, pos, newAmount);
                break;
            }
            case PICKUP_ONE: 
            case DROP_ONE_SLOT: {
                assert (currentItem != null);
                if (currentItem.getAmount() == 1) {
                    this.dispatchRemove((Cancellable)event, section, pos);
                    break;
                }
                this.dispatchAmount((Cancellable)event, section, pos, currentItem.getAmount() - 1);
                break;
            }
            case MOVE_TO_OTHER_INVENTORY: {
                Inventory bottomInventory = event.getView().getBottomInventory();
                if (bottomInventory.firstEmpty() != -1) {
                    this.dispatchRemove((Cancellable)event, section, pos);
                    return;
                }
                assert (currentItem != null);
                int availible = 0;
                for (ItemStack item : bottomInventory.getContents()) {
                    if (!currentItem.isSimilar(item)) continue;
                    assert (item != null);
                    availible += 64 - item.getAmount();
                }
                if (availible == 0) {
                    return;
                }
                if (currentItem.getAmount() > availible) {
                    this.dispatchAmount((Cancellable)event, section, pos, currentItem.getAmount() - availible);
                    break;
                }
                this.dispatchRemove((Cancellable)event, section, pos);
                break;
            }
            case PICKUP_ALL: 
            case DROP_ALL_SLOT: {
                this.dispatchRemove((Cancellable)event, section, pos);
                break;
            }
            case PLACE_ALL: {
                if (currentItem == null) {
                    int newAmount = event.getCursor().getAmount();
                    this.dispatchAdd((Cancellable)event, section, pos, event.getCursor(), newAmount);
                    break;
                }
                int newAmount = currentItem.getAmount() + event.getCursor().getAmount();
                this.dispatchAmount((Cancellable)event, section, pos, newAmount);
                break;
            }
            case PLACE_ONE: {
                if (currentItem == null) {
                    this.dispatchAdd((Cancellable)event, section, pos, event.getCursor(), 1);
                    break;
                }
                this.dispatchAmount((Cancellable)event, section, pos, currentItem.getAmount() + 1);
                break;
            }
            case HOTBAR_SWAP: {
                if (currentItem == null) {
                    ItemStack hotbarItem = GUI.getHotbarItem(event);
                    this.dispatchAdd((Cancellable)event, section, pos, hotbarItem, hotbarItem.getAmount());
                    break;
                }
                this.dispatchRemove((Cancellable)event, section, pos);
                break;
            }
            case HOTBAR_MOVE_AND_READD: {
                ItemStack hotbarItem = GUI.getHotbarItem(event);
                if (hotbarItem.isSimilar(currentItem)) {
                    this.dispatchAmount((Cancellable)event, section, pos, hotbarItem.getAmount());
                    break;
                }
                this.dispatchRemove((Cancellable)event, section, pos);
                this.dispatchAdd((Cancellable)event, section, pos, hotbarItem, hotbarItem.getAmount());
                break;
            }
            default: {
                event.setCancelled(true);
            }
        }
    }

    private static ItemStack getHotbarItem(InventoryClickEvent event) {
        Inventory bottomInventory = event.getView().getBottomInventory();
        return bottomInventory.getItem(event.getHotbarButton());
    }

    public void dispatchAdd(Cancellable event, GUISection section, Vector2d position, ItemStack item, int amount) {
        item = item.clone();
        item.setAmount(amount);
        if (section.onItemAdd(position, item)) {
            event.setCancelled(true);
        }
    }

    public void dispatchRemove(Cancellable event, GUISection section, Vector2d position) {
        if (section.onItemRemove(position)) {
            event.setCancelled(true);
        }
    }

    public void dispatchAmount(Cancellable event, GUISection section, Vector2d position, int amount) {
        if (section.onItemAmount(position, amount)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (event.isCancelled()) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        GUIView view = this.getView(event.getInventory());
        if (view == null) {
            return;
        }
        List<Integer> guiSlots = event.getRawSlots().stream().filter(s -> s < this.getSlots()).toList();
        Map<GUISection.SearchData, Integer> sectionSlots = this.getSections(guiSlots);
        Map<Integer, ItemStack> cancelledSlots = this.getCancelledSlots(event, sectionSlots);
        this.returnToCursor(event, cancelledSlots);
        this.removeItems(view, cancelledSlots);
    }

    private void removeItems(GUIView view, Map<Integer, ItemStack> cancelledSlots) {
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            for (Integer slot : cancelledSlots.keySet()) {
                ItemStack item = view.getInventory().getItem(slot.intValue());
                if (item == null) continue;
                int amount = ((ItemStack)cancelledSlots.get(slot)).getAmount();
                item.setAmount(item.getAmount() - amount);
            }
        }, 1L);
    }

    private void returnToCursor(InventoryDragEvent event, Map<Integer, ItemStack> cancelledSlots) {
        ItemStack cursor = event.getCursor();
        for (Integer slot : cancelledSlots.keySet()) {
            ItemStack itemStack = cancelledSlots.get(slot);
            if (cursor != null) {
                cursor.setAmount(cursor.getAmount() + itemStack.getAmount());
                continue;
            }
            cursor = itemStack.clone();
        }
        event.setCursor(cursor);
    }

    private Map<Integer, ItemStack> getCancelledSlots(InventoryDragEvent event, Map<GUISection.SearchData, Integer> sectionSlots) {
        HashMap<Integer, ItemStack> removedItems = new HashMap<Integer, ItemStack>();
        for (GUISection.SearchData searchData : sectionSlots.keySet()) {
            GUISection section = searchData.getSection();
            int slot = sectionSlots.get(searchData);
            ItemStack newItem = ((ItemStack)event.getNewItems().get(slot)).clone();
            ItemStack existingItem = event.getView().getItem(slot);
            if (existingItem == null) {
                if (!section.onItemAdd(searchData.getRelativePos(), newItem)) continue;
                removedItems.put(slot, newItem);
                continue;
            }
            if (!section.onItemAmount(searchData.getRelativePos(), newItem.getAmount())) continue;
            newItem.setAmount(newItem.getAmount() - existingItem.getAmount());
            removedItems.put(slot, newItem);
        }
        return removedItems;
    }

    private Map<GUISection.SearchData, Integer> getSections(List<Integer> guiSlots) {
        HashMap<GUISection.SearchData, Integer> sectionSlots = new HashMap<GUISection.SearchData, Integer>();
        for (Integer guiSlot : guiSlots) {
            GUISection.SearchData searchData = this.searchSection(guiSlot, true);
            sectionSlots.put(searchData, guiSlot);
        }
        return sectionSlots;
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        GUIView view = this.getView(event.getInventory());
        if (view != null) {
            this.removePlayer(view);
        }
    }

    private void removePlayer(GUIView view) {
        this.views.remove(view);
        this.onClose(view.getPlayer());
        if (this.views.size() == 0) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    public void onClose(Player player) {
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public TextComponent getTitle() {
        return this.title;
    }

    public List<GUIView> getViews() {
        return this.views;
    }

    public InventoryType getType() {
        return this.type;
    }

    public List<ItemStack> getContent() {
        return this.content;
    }
}

