/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.interaction.impl;

import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.content.item.GUIButton;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.interaction.InteractionHandler;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryEvent;

public class ButtonClickHandler
extends InteractionHandler {
    public ButtonClickHandler(GUI gui) {
        super(gui);
    }

    @Override
    public boolean onClick(InventoryClickEvent event) {
        GUIButton button;
        ClickType clickType = event.getClick();
        boolean leftClick = clickType.isLeftClick();
        boolean rightClick = clickType.isRightClick();
        if (!leftClick && !rightClick) {
            return false;
        }
        int slot = event.getSlot();
        GUISection clicked = this.gui.getClickedSection(slot);
        Player player = (Player)event.getWhoClicked();
        ClickData clickData = new ClickData(player, slot, event.getAction(), (InventoryEvent)event);
        if (clicked instanceof GUIButton && (button = (GUIButton)clicked).hasPermission(player)) {
            button.click(player);
            if (event.isShiftClick()) {
                button.onShiftClick(clickData);
                if (leftClick) {
                    button.onShiftLeftClick(clickData);
                } else {
                    button.onShiftRightClick(clickData);
                }
            } else {
                button.onClick(clickData);
                if (leftClick) {
                    button.onLeftClick(clickData);
                } else {
                    button.onRightClick(clickData);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onDrag(InventoryDragEvent event) {
        return false;
    }
}

