/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.gui;

import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.gui.GUIView;
import de.placeblock.betterinventories.interaction.HandlerPriority;
import de.placeblock.betterinventories.interaction.InteractionHandler;
import de.placeblock.betterinventories.interaction.impl.ButtonClickHandler;
import de.placeblock.betterinventories.interaction.impl.CancelInteractionHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.function.Function;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public abstract class GUI
implements Listener {
    private final Plugin plugin;
    private final TextComponent title;
    private final List<GUIView> views = new ArrayList<GUIView>();
    private final InventoryType type;
    private List<ItemStack> content = new ArrayList<ItemStack>();
    private final SortedSetMultimap<HandlerPriority, InteractionHandler> interactionHandlers = TreeMultimap.create(Comparator.comparingInt(Enum::ordinal), Comparator.comparing(Object::hashCode));

    public GUI(Plugin plugin, TextComponent title, InventoryType type) {
        this(plugin, title, type, true);
    }

    public GUI(Plugin plugin, TextComponent title, InventoryType type, boolean registerDefaultHandlers) {
        this.plugin = plugin;
        this.type = type;
        this.title = title;
        if (registerDefaultHandlers) {
            this.registerInteractionHandler(HandlerPriority.HIGH, new CancelInteractionHandler(this));
            this.registerInteractionHandler(HandlerPriority.LOW, new ButtonClickHandler(this));
        }
    }

    public abstract Inventory createBukkitInventory();

    public GUIView showPlayer(Player player) {
        if (this.views.size() == 0) {
            this.plugin.getServer().getPluginManager().registerEvents((Listener)this, this.plugin);
        }
        if (this.getPlayers().contains(player)) {
            return null;
        }
        GUIView view = new GUIView(player, this.createBukkitInventory());
        view.update(this.content);
        this.views.add(view);
        return view;
    }

    public List<Player> getPlayers() {
        return this.views.stream().map(GUIView::getPlayer).toList();
    }

    public GUIView getView(Inventory inventory) {
        for (GUIView view : this.views) {
            if (!view.getInventory().equals(inventory)) continue;
            return view;
        }
        return null;
    }

    public void reloadViews() {
        List<Player> players = this.getPlayers();
        ArrayList<GUIView> views = new ArrayList<GUIView>(this.getViews());
        for (GUIView view : views) {
            this.removePlayer(view);
        }
        for (Player player : players) {
            this.showPlayer(player);
        }
    }

    public abstract int getSlots();

    public abstract List<ItemStack> renderContent();

    public abstract GUISection getClickedSection(int var1);

    public void update() {
        this.render();
        this.updateViews();
    }

    protected void render() {
        this.content = this.renderContent();
    }

    protected void updateViews() {
        for (GUIView view : this.views) {
            view.update(this.content);
        }
    }

    public void registerInteractionHandler(HandlerPriority priority, InteractionHandler handler) {
        this.interactionHandlers.put((Object)priority, (Object)handler);
    }

    public void unregisterInteractionHandler(HandlerPriority priority, InteractionHandler handler) {
        this.interactionHandlers.remove((Object)priority, (Object)handler);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        GUIView view = this.getView(event.getInventory());
        if (view == null) {
            return;
        }
        this.handleInteraction(i -> i.onClick(event));
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        GUIView view = this.getView(event.getInventory());
        if (view == null) {
            return;
        }
        this.handleInteraction(i -> i.onDrag(event));
    }

    private void handleInteraction(Function<InteractionHandler, Boolean> handler) {
        block0: for (HandlerPriority priority : this.interactionHandlers.keySet()) {
            SortedSet pInteractionHandlers = this.interactionHandlers.get((Object)priority);
            for (InteractionHandler interactionHandler : pInteractionHandlers) {
                boolean processed = handler.apply(interactionHandler);
                if (!processed) continue;
                break block0;
            }
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        GUIView view = this.getView(event.getInventory());
        if (view != null) {
            this.removePlayer(view);
        }
    }

    private void removePlayer(GUIView view) {
        this.views.remove(view);
        this.onClose(view.getPlayer());
        if (this.views.size() == 0) {
            HandlerList.unregisterAll((Listener)this);
        }
    }

    public void onClose(Player player) {
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public TextComponent getTitle() {
        return this.title;
    }

    public List<GUIView> getViews() {
        return this.views;
    }

    public InventoryType getType() {
        return this.type;
    }

    public List<ItemStack> getContent() {
        return this.content;
    }

    public SortedSetMultimap<HandlerPriority, InteractionHandler> getInteractionHandlers() {
        return this.interactionHandlers;
    }
}

