/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.gui.impl;

import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.gui.GUI;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class AnvilGUI
extends GUI {
    private GUIItem inputItem;
    private GUIItem additionalItem;
    private GUIItem resultItem;

    public AnvilGUI(Plugin plugin, TextComponent title) {
        super(plugin, title, InventoryType.ANVIL);
    }

    public AnvilGUI(Plugin plugin, TextComponent title, boolean registerDefaultHandlers) {
        super(plugin, title, InventoryType.ANVIL, registerDefaultHandlers);
    }

    @Override
    public Inventory createBukkitInventory() {
        return Bukkit.createInventory(null, (InventoryType)InventoryType.ANVIL, (Component)this.getTitle());
    }

    @Override
    public int getSlots() {
        return 3;
    }

    @Override
    public List<ItemStack> renderContent() {
        ItemStack inputItem = this.inputItem == null ? null : this.inputItem.getItemStack();
        ItemStack additionalItem = this.additionalItem == null ? null : this.additionalItem.getItemStack();
        ItemStack resultItem = this.resultItem == null ? null : this.resultItem.getItemStack();
        return Arrays.asList(inputItem, additionalItem, resultItem);
    }

    @Override
    public GUISection getClickedSection(int slot) {
        return switch (slot) {
            case 0 -> this.inputItem;
            case 1 -> this.additionalItem;
            case 2 -> this.resultItem;
            default -> null;
        };
    }

    public GUIItem getInputItem() {
        return this.inputItem;
    }

    public GUIItem getAdditionalItem() {
        return this.additionalItem;
    }

    public GUIItem getResultItem() {
        return this.resultItem;
    }

    public void setInputItem(GUIItem inputItem) {
        this.inputItem = inputItem;
    }

    public void setAdditionalItem(GUIItem additionalItem) {
        this.additionalItem = additionalItem;
    }

    public void setResultItem(GUIItem resultItem) {
        this.resultItem = resultItem;
    }
}

