/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.pane.impl.simple;

import de.placeblock.betterinventories.Sizeable;
import de.placeblock.betterinventories.content.GUISection;
import de.placeblock.betterinventories.content.item.GUIItem;
import de.placeblock.betterinventories.content.pane.GUIPane;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.Vector2d;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.inventory.ItemStack;

public class BaseSimpleGUIPane<C extends GUISection, S extends BaseSimpleGUIPane<C, S>>
extends GUIPane {
    protected final List<ChildData<C>> content = new ArrayList<ChildData<C>>();
    protected final boolean autoSize;

    public BaseSimpleGUIPane(GUI gui, Vector2d minSize, Vector2d maxSize, boolean autoSize) {
        super(gui, minSize, maxSize);
        this.autoSize = autoSize;
    }

    @Override
    public void updateSizeRecursive(Sizeable parent) {
        this.updateChildrenRecursive(parent);
        this.updateSize(parent);
    }

    @Override
    public void updateSize(Sizeable parent) {
        if (this.autoSize) {
            HashSet<Vector2d> vectors = new HashSet<Vector2d>();
            for (ChildData<C> childData : this.content) {
                vectors.add(childData.getPosition().add(((GUISection)childData.getChild()).getSize()));
            }
            this.setSize(Vector2d.largest(vectors));
        }
    }

    @Override
    public Set<GUISection> getChildren() {
        return this.content.stream().map(ChildData::getChild).collect(Collectors.toSet());
    }

    @Override
    public List<ItemStack> render() {
        List<ItemStack> content = this.getEmptyContentList(ItemStack.class);
        if (!content.isEmpty()) {
            for (ChildData<C> childData : this.content) {
                this.renderOnList((GUISection)childData.getChild(), childData.getPosition(), content);
            }
        }
        return content;
    }

    @Override
    public GUISection getSectionAt(Vector2d position) {
        if (position == null) {
            return null;
        }
        for (int i = this.content.size() - 1; i >= 0; --i) {
            ChildData<C> childData = this.content.get(i);
            Vector2d pos = childData.getPosition();
            C section = childData.getChild();
            if (pos.getX() > position.getX() || pos.getX() + ((GUISection)section).getWidth() - 1 < position.getX() || pos.getY() > position.getY() || pos.getY() + ((GUISection)section).getHeight() - 1 < position.getY()) continue;
            return ((GUISection)section).getSectionAt(position.subtract(pos));
        }
        return null;
    }

    public S addItemEmptySlot(GUIItem item) {
        int nextEmptySlot = this.getNextEmptySlot();
        if (nextEmptySlot == -1) {
            return (S)this;
        }
        this.setSectionAt(nextEmptySlot, item);
        return (S)this;
    }

    public S fill(GUIItem item) {
        while (this.getNextEmptySlot() != -1) {
            this.addItemEmptySlot(item);
        }
        return (S)this;
    }

    private int getNextEmptySlot() {
        for (int i = 0; i < this.getSlots(); ++i) {
            if (this.getSectionAt(this.slotToVector(i)) != null) continue;
            return i;
        }
        return -1;
    }

    public boolean removeSection(C section) {
        ChildData<C> removal = null;
        for (ChildData<C> childData : this.content) {
            if (!childData.getChild().equals(section)) continue;
            removal = childData;
        }
        if (removal != null) {
            this.content.remove(removal);
            return true;
        }
        return false;
    }

    public S clear() {
        this.content.clear();
        return (S)this;
    }

    public S setSectionAt(int slot, C section) {
        return this.setSectionAt(this.slotToVector(slot), section);
    }

    public S setSectionAt(Vector2d position, C section) {
        this.content.add(new ChildData<C>(position, section));
        return (S)this;
    }

    public S setSection(C section) {
        return this.setSectionAt(new Vector2d(), section);
    }

    protected static class ChildData<C extends GUISection> {
        private Vector2d position;
        private final C child;

        public Vector2d getPosition() {
            return this.position;
        }

        public C getChild() {
            return this.child;
        }

        public ChildData(Vector2d position, C child) {
            this.position = position;
            this.child = child;
        }

        public void setPosition(Vector2d position) {
            this.position = position;
        }
    }
}

