/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.content.item.impl.cyclebutton;

import de.placeblock.betterinventories.content.item.ClickData;
import de.placeblock.betterinventories.content.item.GUIButton;
import de.placeblock.betterinventories.content.item.impl.cyclebutton.CycleEnum;
import de.placeblock.betterinventories.gui.GUI;
import de.placeblock.betterinventories.util.ItemBuilder;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class CycleGUIButton<E extends CycleEnum>
extends GUIButton {
    private final List<E> values;
    private E currentValue;

    public CycleGUIButton(GUI gui, E[] values) {
        this(gui, (CycleEnum[])values, (CycleEnum)values[0]);
    }

    public CycleGUIButton(GUI gui, E[] values, E startValue) {
        super(gui, null);
        this.values = List.of(values);
        this.currentValue = startValue;
        this.updateItem();
    }

    protected ItemStack getItem(E value) {
        return new ItemBuilder(value.getTitle(), value.getMaterial()).lore(value.getLore()).build();
    }

    public void cycle(ClickData data) {
        this.currentValue = this.getNextValue(data.getPlayer(), this.currentValue, this.getNextValue(this.currentValue));
        this.updateItem();
        this.getGui().update();
        this.onCycle(data, this.currentValue);
    }

    private E getNextValue(Player player, E startValue, E nextValue) {
        if (nextValue == startValue) {
            return startValue;
        }
        String permission = nextValue.getPermission();
        if (permission == null || player.hasPermission(permission)) {
            return nextValue;
        }
        return this.getNextValue(player, startValue, this.getNextValue(nextValue));
    }

    private E getNextValue(E currentValue) {
        int currentIndex = this.values.indexOf(currentValue);
        int newIndex = ++currentIndex % this.values.size();
        return (E)((CycleEnum)this.values.get(newIndex));
    }

    private void updateItem() {
        this.setItemStack(this.getItem(this.currentValue));
    }

    protected abstract void onCycle(ClickData var1, E var2);

    public E getCurrentValue() {
        return this.currentValue;
    }
}

