/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.builder.gui;

import de.placeblock.betterinventories.builder.Builder;
import de.placeblock.betterinventories.gui.GUI;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public abstract class BaseGUIBuilder<G extends GUI, B extends BaseGUIBuilder<G, B>>
implements Builder<G, B> {
    private final Plugin plugin;
    private TextComponent title;
    private InventoryType type;
    private boolean registerDefaultHandlers = true;

    public B title(@NotNull TextComponent title) {
        this.title = title;
        return (B)this;
    }

    public B type(@NotNull InventoryType type) {
        this.type = type;
        return (B)this;
    }

    public B registerDefaultHandlers(boolean register) {
        this.registerDefaultHandlers = register;
        return (B)this;
    }

    protected TextComponent getTitle() {
        return this.getValue(this.title);
    }

    protected InventoryType getType() {
        return this.getValue(this.type);
    }

    protected Plugin getPlugin() {
        return this.plugin;
    }

    protected boolean getRegisterDefaultHandlers() {
        return this.registerDefaultHandlers;
    }

    @Override
    public abstract G build();

    public BaseGUIBuilder(Plugin plugin) {
        this.plugin = plugin;
    }
}

