/*
 * Decompiled with CFR 0.152.
 */
package de.placeblock.betterinventories.builder;

import java.util.List;
import java.util.function.Supplier;

public interface Builder<G, B extends Builder<G, B>> {
    public static final IllegalStateException VALUE_MISSING_EXCEPTION = new IllegalStateException("Required value not found in Builder");

    public G build();

    default public <T> T getValue(Supplier<T> location) {
        return this.getValue(location.get());
    }

    default public <T> T getValue(T value) {
        if (value != null) {
            return value;
        }
        throw VALUE_MISSING_EXCEPTION;
    }

    default public <T> T getValue(List<Supplier<T>> locations) {
        for (Supplier<T> location : locations) {
            T value = location.get();
            if (value == null) continue;
            return value;
        }
        throw VALUE_MISSING_EXCEPTION;
    }
}

