/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.zucchini.web.steps;

import de.codecentric.zucchini.web.steps.AbstractWebStep;
import de.codecentric.zucchini.web.steps.SelectContext;
import de.codecentric.zucchini.web.util.WebAssert;
import org.openqa.selenium.support.ui.Select;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectStep
extends AbstractWebStep {
    private static final Logger logger = LoggerFactory.getLogger(SelectStep.class);
    private SelectContext selectContext;
    private Object optionSelector;
    private OptionSelectorType optionSelectorType;

    public SelectStep(SelectContext selectContext, Object optionSelector, OptionSelectorType optionSelectorType) {
        this.selectContext = selectContext;
        this.optionSelector = optionSelector;
        this.optionSelectorType = optionSelectorType;
    }

    public void go() {
        logger.info("Waiting for select {}...", (Object)this.selectContext.getElement());
        Select select = new Select(WebAssert.findElementOrFail(this.getWebDriver(), this.selectContext.getElement()));
        if (OptionSelectorType.INDEX.equals((Object)this.optionSelectorType)) {
            logger.info("Selecting index {}...", this.optionSelector);
            select.selectByIndex(((Integer)this.optionSelector).intValue());
        } else if (OptionSelectorType.VALUE.equals((Object)this.optionSelectorType)) {
            logger.info("Selecting value {}...", this.optionSelector);
            select.selectByValue((String)this.optionSelector);
        } else if (OptionSelectorType.TEXT.equals((Object)this.optionSelectorType)) {
            logger.info("Selecting text {}...", this.optionSelector);
            select.selectByVisibleText((String)this.optionSelector);
        }
    }

    public static enum OptionSelectorType {
        VALUE,
        TEXT,
        INDEX;

    }
}

