/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.zucchini.web;

import de.codecentric.zucchini.bdd.AbstractExecutor;
import de.codecentric.zucchini.bdd.ExecutionContext;
import de.codecentric.zucchini.bdd.ExecutionException;
import de.codecentric.zucchini.bdd.dsl.DelegatingStatement;
import de.codecentric.zucchini.bdd.dsl.ExecutionFact;
import de.codecentric.zucchini.bdd.dsl.Fact;
import de.codecentric.zucchini.bdd.dsl.Result;
import de.codecentric.zucchini.bdd.dsl.Statement;
import de.codecentric.zucchini.bdd.dsl.Step;
import de.codecentric.zucchini.bdd.dsl.impl.facts.DelegatingFact;
import de.codecentric.zucchini.bdd.dsl.impl.results.DelegatingResult;
import de.codecentric.zucchini.bdd.dsl.impl.steps.DelegatingStep;
import de.codecentric.zucchini.web.WebDriverAware;
import de.codecentric.zucchini.web.facts.WebFact;
import de.codecentric.zucchini.web.provider.ChromeDriverProvider;
import de.codecentric.zucchini.web.provider.WebDriverProvider;
import de.codecentric.zucchini.web.results.WebResult;
import de.codecentric.zucchini.web.steps.WebStep;

public class WebDriverExecutor
extends AbstractExecutor {
    private WebDriverProvider webDriverProvider;

    public WebDriverExecutor() {
        this(new ChromeDriverProvider());
    }

    public WebDriverExecutor(WebDriverProvider webDriverProvider) {
        if (webDriverProvider == null) {
            throw new NullPointerException("The WebDriverExecutor expects the WebDriverProvider to be non-null.");
        }
        this.webDriverProvider = webDriverProvider;
    }

    public WebDriverProvider getWebDriverProvider() {
        return this.webDriverProvider;
    }

    protected void initialize() {
        this.webDriverProvider.startWebDriver();
    }

    protected void shutdown() {
        this.webDriverProvider.stopWebDriver();
    }

    protected void prepareStatement(Statement statement) {
        if (statement instanceof DelegatingStatement) {
            this.injectWebDriver(((DelegatingStatement)statement).getStatement());
        } else {
            this.injectWebDriver(statement);
        }
    }

    private void injectWebDriver(Statement statement) {
        if (statement instanceof WebDriverAware) {
            ((WebDriverAware)statement).setWebDriver(this.webDriverProvider.getWebDriver());
        }
    }

    protected void failOnInvalidContext(ExecutionContext executionContext) {
        for (Fact fact : executionContext.getFacts()) {
            if (fact instanceof DelegatingFact) {
                DelegatingFact delegatingFact = (DelegatingFact)fact;
                this.failOnInvalidFact(delegatingFact.getStatement());
                continue;
            }
            this.failOnInvalidFact(fact);
        }
        for (Step step : executionContext.getSteps()) {
            if (step instanceof DelegatingStep) {
                DelegatingStep delegatingStep = (DelegatingStep)step;
                this.failOnInvalidStep(delegatingStep.getStatement());
                continue;
            }
            this.failOnInvalidStep(step);
        }
        for (Result result : executionContext.getResults()) {
            if (result instanceof DelegatingResult) {
                DelegatingResult delegatingResult = (DelegatingResult)result;
                this.failOnInvalidResult(delegatingResult.getStatement());
                continue;
            }
            this.failOnInvalidResult(result);
        }
    }

    private void failOnInvalidFact(Fact fact) {
        if (!(fact instanceof WebFact) && !(fact instanceof ExecutionFact)) {
            throw new ExecutionException("Invalid facts detected. The WebDriverExecutor only supports WebFact implementations.");
        }
    }

    private void failOnInvalidStep(Step step) {
        if (!(step instanceof WebStep)) {
            throw new ExecutionException("Invalid step detected. The WebDriverExecutor only supports WebCondition implementations.");
        }
    }

    private void failOnInvalidResult(Result result) {
        if (!(result instanceof WebResult)) {
            throw new ExecutionException("Invalid result detected. The WebDriverExecutor only supports WebResult implementations.");
        }
    }
}

