/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.zucchini.web.steps;

import de.codecentric.zucchini.bdd.ExecutionException;
import de.codecentric.zucchini.web.steps.AbstractWebStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitStep
extends AbstractWebStep {
    private static final Logger logger = LoggerFactory.getLogger(WaitStep.class);
    private static final long DEFAULT_SLEEP_TIME = 10L;
    private long sleepTime;

    public WaitStep() {
        this.sleepTime = 10L;
    }

    public WaitStep(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public WaitStep withSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
        return this;
    }

    public void go() {
        logger.info("Waiting {} seconds...", (Object)this.sleepTime);
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException e) {
            throw new ExecutionException("Thread could not sleep.", (Throwable)e);
        }
    }
}

