/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.zucchini.web.steps;

import com.google.common.base.Function;
import de.codecentric.zucchini.bdd.util.Assert;
import de.codecentric.zucchini.web.steps.AbstractWebStep;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForStep
extends AbstractWebStep {
    private static final Logger logger = LoggerFactory.getLogger(WaitForStep.class);
    private static final long DEFAULT_TIMEOUT = 10L;
    private By element;
    private long timeout;

    public WaitForStep(By element) {
        this(element, 10L);
    }

    public WaitForStep(By element, long timeout) {
        this.element = element;
        this.timeout = timeout;
    }

    public WaitForStep withTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public void go() {
        logger.info("Waiting {} seconds for {}...", (Object)this.timeout, (Object)this.element);
        WebDriverWait waiting = new WebDriverWait(this.getWebDriver(), this.timeout);
        try {
            waiting.until((Function)ExpectedConditions.presenceOfElementLocated((By)this.element));
        }
        catch (NullPointerException e) {
            Assert.fail((String)String.format("Element %s did not appear within %d seconds.", this.element, this.timeout));
        }
    }
}

