/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.zucchini.web.provider;

import de.codecentric.zucchini.web.provider.WebDriverProvider;
import org.openqa.selenium.WebDriver;

public abstract class AbstractWebDriverProvider
implements WebDriverProvider {
    private WebDriver webDriver;
    private int nestingLevel = 0;

    @Override
    public void startWebDriver() {
        if (this.webDriver == null) {
            this.webDriver = this.createWebDriver();
        }
        ++this.nestingLevel;
    }

    @Override
    public void stopWebDriver() {
        --this.nestingLevel;
        if (this.webDriver != null && this.nestingLevel == 0) {
            this.webDriver.close();
            this.webDriver.quit();
            this.webDriver = null;
        }
    }

    @Override
    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    protected abstract WebDriver createWebDriver();
}

