/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.zucchini.web.steps;

import com.google.common.base.Function;
import de.codecentric.zucchini.bdd.ExecutionException;
import de.codecentric.zucchini.web.steps.AbstractWebStep;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WaitForStep
extends AbstractWebStep {
    private static final long DEFAULT_TIMEOUT = 10000L;
    private By element;
    private long timeout;

    public WaitForStep(By element) {
        this(element, 10000L);
    }

    public WaitForStep(By element, long timeout) {
        this.element = element;
        this.timeout = timeout;
    }

    public WaitForStep withTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public void go() {
        WebDriverWait waiting = new WebDriverWait(this.getWebDriver(), this.timeout);
        try {
            waiting.until((Function)ExpectedConditions.presenceOfElementLocated((By)this.element));
        }
        catch (NullPointerException e) {
            throw new ExecutionException(String.format("Element [%s] did not appear within %d ms.", this.element.toString(), this.timeout), (Throwable)e);
        }
    }
}

