/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.zucchini.web;

import de.codecentric.zucchini.bdd.AbstractExecutor;
import de.codecentric.zucchini.bdd.ExecutionContext;
import de.codecentric.zucchini.bdd.ExecutionException;
import de.codecentric.zucchini.bdd.dsl.Fact;
import de.codecentric.zucchini.bdd.dsl.Result;
import de.codecentric.zucchini.bdd.dsl.Statement;
import de.codecentric.zucchini.bdd.dsl.Step;
import de.codecentric.zucchini.web.WebDriverAware;
import de.codecentric.zucchini.web.facts.WebFact;
import de.codecentric.zucchini.web.provider.HtmlUnitDriverProvider;
import de.codecentric.zucchini.web.provider.WebDriverProvider;
import de.codecentric.zucchini.web.results.WebResult;
import de.codecentric.zucchini.web.steps.WebStep;

public class WebDriverExecutor
extends AbstractExecutor {
    private WebDriverProvider webDriverProvider;

    public WebDriverExecutor() {
        this(new HtmlUnitDriverProvider());
    }

    public WebDriverExecutor(WebDriverProvider webDriverProvider) {
        if (webDriverProvider == null) {
            throw new NullPointerException("The WebDriverExecutor expects the WebDriverProvider to be non-null.");
        }
        this.webDriverProvider = webDriverProvider;
    }

    protected void initialize() {
        this.webDriverProvider.startWebDriver();
    }

    protected void shutdown() {
        this.webDriverProvider.stopWebDriver();
    }

    protected void prepareStatement(Statement statement) {
        if (statement instanceof WebDriverAware) {
            ((WebDriverAware)statement).setWebDriver(this.webDriverProvider.getWebDriver());
        }
    }

    protected void failOnInvalidContext(ExecutionContext executionContext) {
        for (Fact fact : executionContext.getFacts()) {
            if (fact instanceof WebFact) continue;
            throw new ExecutionException("Invalid facts detected. The WebDriverExecutor only supports WebFact implementations.");
        }
        for (Step step : executionContext.getSteps()) {
            if (step instanceof WebStep) continue;
            throw new ExecutionException("Invalid step detected. The WebDriverExecutor only supports WebCondition implementations.");
        }
        for (Result result : executionContext.getResults()) {
            if (result instanceof WebResult) continue;
            throw new ExecutionException("Invalid result detected. The WebDriverExecutor only supports WebResult implementations.");
        }
    }
}

