/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.zucchini.web.junit;

import de.codecentric.zucchini.bdd.Executor;
import de.codecentric.zucchini.bdd.ExecutorHolder;
import de.codecentric.zucchini.web.WebDriverExecutor;
import de.codecentric.zucchini.web.provider.WebDriverProvider;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class WebDriverExecutorRule
implements TestRule {
    private WebDriverExecutor webDriverExecutor;
    private WebDriverProvider webDriverProvider;

    public WebDriverExecutorRule() {
    }

    public WebDriverExecutorRule(WebDriverExecutor webDriverExecutor) {
        this.webDriverExecutor = webDriverExecutor;
    }

    public WebDriverExecutorRule(WebDriverProvider webDriverProvider) {
        this.webDriverProvider = webDriverProvider;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ExecutorHolder.setExecutor((Executor)WebDriverExecutorRule.this.getWebDriverExecutor());
                base.evaluate();
            }
        };
    }

    public WebDriverExecutor getWebDriverExecutor() {
        if (this.webDriverExecutor == null) {
            this.webDriverExecutor = this.webDriverProvider == null ? new WebDriverExecutor() : new WebDriverExecutor(this.webDriverProvider);
        }
        return this.webDriverExecutor;
    }
}

