/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.monitoring;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RunningExecutionTracker {
    private Map<Long, String> runningExecutions = new ConcurrentHashMap<Long, String>();

    public void addRunningExecution(String jobName, Long executionId) {
        this.runningExecutions.put(executionId, jobName);
    }

    public void removeRunningExecution(Long executionId) {
        this.runningExecutions.remove(executionId);
    }

    public Set<Long> getAllRunningExecutionIds() {
        return new HashSet<Long>(this.runningExecutions.keySet());
    }

    public Set<Long> getRunningExecutionIdsForJobName(String jobName) {
        HashSet<Long> runningExecutionIds = new HashSet<Long>();
        for (Map.Entry<Long, String> entry : this.runningExecutions.entrySet()) {
            if (!entry.getValue().equals(jobName)) continue;
            runningExecutionIds.add(entry.getKey());
        }
        return runningExecutionIds;
    }
}

