/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.metrics;

import de.codecentric.batch.metrics.MetricsOutputFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.export.Exporter;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.actuate.metrics.rich.RichGauge;
import org.springframework.boot.actuate.metrics.rich.RichGaugeReader;
import org.springframework.core.Ordered;

public class MetricsListener
extends StepExecutionListenerSupport
implements Ordered,
JobExecutionListener {
    private static final Log LOGGER = LogFactory.getLog(MetricsListener.class);
    public static final String GAUGE_PREFIX = "gauge.batch.";
    public static final String TIMER_PREFIX = "timer.batch.";
    private GaugeService gaugeService;
    private RichGaugeReader richGaugeReader;
    private MetricReader metricReader;
    private List<Exporter> exporters;
    private MetricsOutputFormatter metricsOutputFormatter = new SimpleMetricsOutputFormatter();

    public MetricsListener(GaugeService gaugeService, RichGaugeReader richGaugeReader, MetricReader metricReader, List<Exporter> exporters) {
        this.gaugeService = gaugeService;
        this.richGaugeReader = richGaugeReader;
        this.metricReader = metricReader;
        this.exporters = exporters;
    }

    public void beforeJob(JobExecution jobExecution) {
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        long stepDuration = System.currentTimeMillis() - stepExecution.getStartTime().getTime();
        this.gaugeService.submit(TIMER_PREFIX + this.getStepExecutionIdentifier(stepExecution) + ".duration", (double)stepDuration);
        long itemCount = stepExecution.getWriteCount() + stepExecution.getSkipCount();
        this.gaugeService.submit(GAUGE_PREFIX + this.getStepExecutionIdentifier(stepExecution) + ".item.count", (double)itemCount);
        long durationPerItem = 0L;
        if (itemCount > 0L) {
            durationPerItem = stepDuration / itemCount;
        }
        this.gaugeService.submit(TIMER_PREFIX + this.getStepExecutionIdentifier(stepExecution) + ".item.duration", (double)durationPerItem);
        Set metrics = stepExecution.getExecutionContext().entrySet();
        for (Map.Entry metric : metrics) {
            if (metric.getValue() instanceof Long) {
                this.gaugeService.submit(GAUGE_PREFIX + this.getStepExecutionIdentifier(stepExecution) + "." + (String)metric.getKey(), (double)((Long)metric.getValue()).longValue());
                continue;
            }
            if (!(metric.getValue() instanceof Double)) continue;
            this.gaugeService.submit(GAUGE_PREFIX + this.getStepExecutionIdentifier(stepExecution) + "." + (String)metric.getKey(), ((Double)metric.getValue()).doubleValue());
        }
        return null;
    }

    public void afterJob(JobExecution jobExecution) {
        long jobDuration = jobExecution.getEndTime().getTime() - jobExecution.getStartTime().getTime();
        this.gaugeService.submit(TIMER_PREFIX + jobExecution.getJobInstance().getJobName() + ".duration", (double)jobDuration);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        LOGGER.info((Object)this.metricsOutputFormatter.format(this.exportBatchRichGauges(), this.exportBatchMetrics()));
        if (this.exporters != null) {
            for (Exporter exporter : this.exporters) {
                if (exporter == null) continue;
                LOGGER.info((Object)("Exporting Metrics with " + exporter.getClass().getName()));
                exporter.export();
            }
        }
    }

    private List<Metric<?>> exportBatchMetrics() {
        ArrayList metrics = new ArrayList();
        for (Metric metric : this.metricReader.findAll()) {
            metrics.add(metric);
        }
        return metrics;
    }

    private List<RichGauge> exportBatchRichGauges() {
        ArrayList<RichGauge> gauges = new ArrayList<RichGauge>();
        for (RichGauge gauge : this.richGaugeReader.findAll()) {
            gauges.add(gauge);
        }
        return gauges;
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    private String getStepExecutionIdentifier(StepExecution stepExecution) {
        return stepExecution.getJobExecution().getJobInstance().getJobName() + "." + stepExecution.getStepName();
    }

    public void setMetricsOutputFormatter(MetricsOutputFormatter metricsOutputFormatter) {
        this.metricsOutputFormatter = metricsOutputFormatter;
    }

    private static class SimpleMetricsOutputFormatter
    implements MetricsOutputFormatter {
        private SimpleMetricsOutputFormatter() {
        }

        @Override
        public String format(List<RichGauge> gauges, List<Metric<?>> metrics) {
            StringBuilder builder = new StringBuilder("\n########## Metrics Start ##########\n");
            if (gauges != null) {
                for (RichGauge richGauge : gauges) {
                    builder.append(richGauge.toString() + "\n");
                }
            }
            if (metrics != null) {
                for (Metric metric : metrics) {
                    builder.append(metric.toString() + "\n");
                }
            }
            builder.append("########## Metrics End ############");
            return builder.toString();
        }
    }
}

