/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.metrics;

import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.util.ClassUtils;
import org.springframework.util.StopWatch;

public abstract class AbstractBatchMetricsAspect {
    private GaugeService gaugeService;
    public static final String TIMER_PREFIX = "timer.batch.";

    public AbstractBatchMetricsAspect(GaugeService gaugeService) {
        this.gaugeService = gaugeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object profileMethod(ProceedingJoinPoint pjp) throws Throwable {
        StopWatch stopWatch = this.startStopWatch();
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            this.gaugeService.submit(TIMER_PREFIX + this.getStepIdentifier() + "." + ClassUtils.getShortName(pjp.getTarget().getClass()) + "." + pjp.getSignature().getName(), (double)this.getTotalTimeMillis(stopWatch));
        }
    }

    private long getTotalTimeMillis(StopWatch stopWatch) {
        stopWatch.stop();
        long duration = stopWatch.getTotalTimeMillis();
        return duration;
    }

    private StopWatch startStopWatch() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        return stopWatch;
    }

    private String getStepIdentifier() {
        StepContext stepContext = StepSynchronizationManager.getContext();
        StepExecution stepExecution = StepSynchronizationManager.getContext().getStepExecution();
        return stepContext.getJobName() + "." + stepExecution.getStepName();
    }
}

