/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.listener;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.core.Ordered;

public class ProtocolListener
implements JobExecutionListener,
Ordered {
    private static final int DEFAULT_WIDTH = 80;
    private static final Log LOGGER = LogFactory.getLog(ProtocolListener.class);

    public void afterJob(JobExecution jobExecution) {
        StringBuilder protocol = new StringBuilder();
        protocol.append("\n");
        protocol.append(this.createFilledLine('*'));
        protocol.append(this.createFilledLine('-'));
        protocol.append("Protocol for " + jobExecution.getJobInstance().getJobName() + " \n");
        protocol.append("  Started:      " + jobExecution.getStartTime() + "\n");
        protocol.append("  Finished:     " + jobExecution.getEndTime() + "\n");
        protocol.append("  Exit-Code:    " + jobExecution.getExitStatus().getExitCode() + "\n");
        protocol.append("  Exit-Descr:   " + jobExecution.getExitStatus().getExitDescription() + "\n");
        protocol.append("  Status:       " + jobExecution.getStatus() + "\n");
        protocol.append("  Content of Job-ExecutionContext:\n");
        for (Map.Entry entry : jobExecution.getExecutionContext().entrySet()) {
            protocol.append("  " + (String)entry.getKey() + "=" + entry.getValue() + "\n");
        }
        protocol.append("  Job-Parameter: \n");
        JobParameters jp = jobExecution.getJobParameters();
        for (Map.Entry entry : jp.getParameters().entrySet()) {
            protocol.append("  " + (String)entry.getKey() + "=" + entry.getValue() + "\n");
        }
        protocol.append(this.createFilledLine('-'));
        for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
            protocol.append("Step " + stepExecution.getStepName() + " \n");
            protocol.append("  ReadCount:    " + stepExecution.getReadCount() + "\n");
            protocol.append("  WriteCount:   " + stepExecution.getWriteCount() + "\n");
            protocol.append("  Commits:      " + stepExecution.getCommitCount() + "\n");
            protocol.append("  SkipCount:    " + stepExecution.getSkipCount() + "\n");
            protocol.append("  Rollbacks:    " + stepExecution.getRollbackCount() + "\n");
            protocol.append("  Filter:       " + stepExecution.getFilterCount() + "\n");
            protocol.append("  Content of Step-ExecutionContext:\n");
            for (Map.Entry entry : stepExecution.getExecutionContext().entrySet()) {
                protocol.append("  " + (String)entry.getKey() + "=" + entry.getValue() + "\n");
            }
            protocol.append(this.createFilledLine('-'));
        }
        protocol.append(this.createFilledLine('*'));
        LOGGER.info((Object)protocol.toString());
    }

    public void beforeJob(JobExecution jobExecution) {
        StringBuilder protocol = new StringBuilder();
        protocol.append(this.createFilledLine('-'));
        protocol.append("Job " + jobExecution.getJobInstance().getJobName() + " started with Job-Execution-Id " + jobExecution.getId() + " \n");
        protocol.append("Job-Parameter: \n");
        JobParameters jp = jobExecution.getJobParameters();
        for (Map.Entry entry : jp.getParameters().entrySet()) {
            protocol.append("  " + (String)entry.getKey() + "=" + entry.getValue() + "\n");
        }
        protocol.append(this.createFilledLine('-'));
        LOGGER.info((Object)protocol.toString());
    }

    public int getOrder() {
        return -2147483638;
    }

    private String createFilledLine(char filler) {
        return StringUtils.leftPad((String)"", (int)80, (char)filler) + "\n";
    }
}

