/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import de.codecentric.batch.scheduling.concurrent.MdcThreadPoolTaskExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;

@Configuration
@ConditionalOnMissingBean(value={TaskExecutor.class})
public class TaskExecutorConfiguration {
    @Autowired
    private Environment env;

    @Bean
    public TaskExecutor taskExecutor() {
        MdcThreadPoolTaskExecutor taskExecutor = new MdcThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize((Integer)this.env.getProperty("batch.core.pool.size", Integer.class, (Object)5));
        taskExecutor.setQueueCapacity((Integer)this.env.getProperty("batch.queue.capacity", Integer.class, (Object)Integer.MAX_VALUE));
        taskExecutor.setMaxPoolSize((Integer)this.env.getProperty("batch.max.pool.size", Integer.class, (Object)Integer.MAX_VALUE));
        taskExecutor.afterPropertiesSet();
        return taskExecutor;
    }
}

