/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import de.codecentric.batch.configuration.ListenerProvider;
import de.codecentric.batch.metrics.BatchMetricsImpl;
import de.codecentric.batch.metrics.MetricsListener;
import de.codecentric.batch.metrics.ReaderProcessorWriterMetricsAspect;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.export.Exporter;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.actuate.metrics.rich.InMemoryRichGaugeRepository;
import org.springframework.boot.actuate.metrics.rich.RichGaugeReader;
import org.springframework.boot.actuate.metrics.rich.RichGaugeRepository;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(value={"batch.metrics.enabled"})
@Configuration
public class MetricsConfiguration
implements ListenerProvider {
    @Autowired
    private RichGaugeReader richGaugeReader;
    @Autowired
    private GaugeService gaugeService;
    @Autowired(required=false)
    private List<Exporter> exporters;
    @Autowired
    private MetricReader metricReader;

    @Bean
    public BatchMetricsImpl batchMetrics() {
        return new BatchMetricsImpl();
    }

    @ConditionalOnProperty(value={"batch.metrics.profiling.readprocesswrite.enabled"})
    @Bean
    public ReaderProcessorWriterMetricsAspect batchMetricsAspects() {
        return new ReaderProcessorWriterMetricsAspect(this.gaugeService);
    }

    @Bean
    public MetricsListener metricsListener() {
        return new MetricsListener(this.gaugeService, this.richGaugeReader, this.metricReader, this.exporters);
    }

    @Override
    public Set<JobExecutionListener> jobExecutionListeners() {
        HashSet<JobExecutionListener> listeners = new HashSet<JobExecutionListener>();
        listeners.add(this.metricsListener());
        return listeners;
    }

    @Override
    public Set<StepExecutionListener> stepExecutionListeners() {
        HashSet<StepExecutionListener> listeners = new HashSet<StepExecutionListener>();
        listeners.add((StepExecutionListener)this.metricsListener());
        return listeners;
    }

    @ConditionalOnProperty(value={"batch.metrics.enabled"})
    @Configuration
    static class MetricsRepositoryConfiguration {
        MetricsRepositoryConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={RichGaugeRepository.class})
        public RichGaugeRepository richGaugeRepository() {
            return new InMemoryRichGaugeRepository();
        }
    }
}

