/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import de.codecentric.batch.configuration.AutomaticJobRegistrarConfigurationSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.support.ApplicationContextFactory;
import org.springframework.batch.core.configuration.support.AutomaticJobRegistrar;
import org.springframework.batch.core.configuration.support.GenericApplicationContextFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

@Configuration
@ConditionalOnMissingBean(value={AutomaticJobRegistrarConfigurationSupport.class})
public class AutomaticJobRegistrarConfiguration
extends AutomaticJobRegistrarConfigurationSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutomaticJobRegistrarConfiguration.class);
    @Autowired
    private Environment env;

    @Override
    protected void addApplicationContextFactories(AutomaticJobRegistrar automaticJobRegistrar) throws Exception {
        this.registerJobsFromXml(automaticJobRegistrar);
        this.registerJobsFromJavaConfig(automaticJobRegistrar);
    }

    protected void registerJobsFromXml(AutomaticJobRegistrar automaticJobRegistrar) throws IOException {
        Resource[] xmlConfigurations;
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        for (Resource resource : xmlConfigurations = resourcePatternResolver.getResources("classpath*:" + this.env.getProperty("batch.config.path.xml", "/META-INF/spring/batch/jobs") + "/*.xml")) {
            LOGGER.info("Register jobs from {}", (Object)resource);
            automaticJobRegistrar.addApplicationContextFactory((ApplicationContextFactory)new GenericApplicationContextFactory(new Object[]{resource}));
        }
    }

    protected void registerJobsFromJavaConfig(AutomaticJobRegistrar automaticJobRegistrar) throws ClassNotFoundException, IOException {
        List<Class<?>> classes = this.findMyTypes(this.env.getProperty("batch.config.package.javaconfig", "spring.batch.jobs"));
        for (Class<?> clazz : classes) {
            LOGGER.info("Register jobs from {}", clazz);
            automaticJobRegistrar.addApplicationContextFactory((ApplicationContextFactory)new GenericApplicationContextFactory(new Object[]{clazz}));
        }
    }

    private List<Class<?>> findMyTypes(String basePackage) throws IOException, ClassNotFoundException {
        Resource[] resources;
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        ArrayList candidates = new ArrayList();
        String packageSearchPath = "classpath*:" + this.resolveBasePackage(basePackage) + "/" + "**/*.class";
        for (Resource resource : resources = resourcePatternResolver.getResources(packageSearchPath)) {
            MetadataReader metadataReader;
            if (!resource.isReadable() || !this.isCandidate(metadataReader = metadataReaderFactory.getMetadataReader(resource))) continue;
            candidates.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
        }
        return candidates;
    }

    private String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }

    private boolean isCandidate(MetadataReader metadataReader) {
        try {
            Class<?> c = Class.forName(metadataReader.getClassMetadata().getClassName());
            if (c.getAnnotation(Configuration.class) != null) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

