/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.metrics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionAwareMetricWriter
extends TransactionSynchronizationAdapter
implements MetricWriter {
    private static final Log log = LogFactory.getLog(TransactionAwareMetricWriter.class);
    private MetricWriter delegate;
    private ThreadLocal<MetricContainer> metricContainer;
    private final Object serviceKey;

    public TransactionAwareMetricWriter(MetricWriter delegate) {
        this.delegate = delegate;
        this.serviceKey = new Object();
        this.metricContainer = new ThreadLocal();
    }

    public void increment(Delta<?> delta) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.initializeMetricContainerAndRegisterTransactionSynchronizationIfNecessary();
            this.metricContainer.get().incrementations.add(delta);
        } else {
            this.delegate.increment(delta);
        }
    }

    private void initializeMetricContainerAndRegisterTransactionSynchronizationIfNecessary() {
        if (!TransactionSynchronizationManager.hasResource((Object)this.serviceKey)) {
            TransactionSynchronizationManager.bindResource((Object)this.serviceKey, (Object)new StringBuffer());
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this);
        }
        if (this.metricContainer.get() == null) {
            this.metricContainer.set(new MetricContainer());
        }
    }

    public void set(Metric<?> value) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.initializeMetricContainerAndRegisterTransactionSynchronizationIfNecessary();
            this.metricContainer.get().gauges.add(value);
        } else {
            this.delegate.set(value);
        }
    }

    public void reset(String metricName) {
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.initializeMetricContainerAndRegisterTransactionSynchronizationIfNecessary();
            this.metricContainer.get().resets.add(metricName);
        } else {
            this.delegate.reset(metricName);
        }
    }

    public void afterCompletion(int status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Entered afterCompletion with status " + status + "."));
        }
        if (status == 0) {
            MetricContainer currentMetricContainer = this.metricContainer.get();
            for (Delta<?> delta : currentMetricContainer.incrementations) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Increment " + delta + "."));
                }
                this.delegate.increment(delta);
            }
            for (Metric metric : currentMetricContainer.gauges) {
                this.delegate.set(metric);
            }
            for (String string : currentMetricContainer.resets) {
                this.delegate.reset(string);
            }
        }
        this.metricContainer.remove();
        if (TransactionSynchronizationManager.hasResource((Object)this.serviceKey)) {
            TransactionSynchronizationManager.unbindResource((Object)this.serviceKey);
        }
    }

    private static class MetricContainer {
        List<Delta<?>> incrementations = new ArrayList();
        List<Metric<?>> gauges = new ArrayList();
        List<String> resets = new ArrayList<String>();

        private MetricContainer() {
        }
    }
}

