/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.metrics;

import de.codecentric.batch.metrics.MetricsOutputFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.repository.MetricRepository;
import org.springframework.boot.actuate.metrics.rich.RichGauge;
import org.springframework.boot.actuate.metrics.rich.RichGaugeRepository;
import org.springframework.core.Ordered;

public class MetricsListener
extends StepExecutionListenerSupport
implements Ordered {
    private static final Log LOGGER = LogFactory.getLog(MetricsListener.class);
    public static final String GAUGE_PREFIX = "gauge.batch.";
    public static final String COUNTER_PREFIX = "counter.batch.";
    private RichGaugeRepository richGaugeRepository;
    private MetricRepository metricRepository;
    private boolean deleteMetricsOnStepFinish;
    @Autowired(required=false)
    private MetricsOutputFormatter metricsOutputFormatter = new SimpleMetricsOutputFormatter();

    public MetricsListener(RichGaugeRepository richGaugeRepository, MetricRepository metricRepository, boolean deleteMetricsOnStepFinish) {
        this.richGaugeRepository = richGaugeRepository;
        this.metricRepository = metricRepository;
        this.deleteMetricsOnStepFinish = deleteMetricsOnStepFinish;
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        List<RichGauge> gauges = this.exportBatchGauges(stepExecution);
        List<Metric<?>> metrics = this.exportBatchMetrics(stepExecution);
        LOGGER.info((Object)this.metricsOutputFormatter.format(gauges, metrics));
        return null;
    }

    private List<Metric<?>> exportBatchMetrics(StepExecution stepExecution) {
        String stepExecutionIdentifier = MDC.get((String)"stepExecutionIdentifier");
        ArrayList metrics = new ArrayList();
        for (Metric metric : this.metricRepository.findAll()) {
            if (!metric.getName().startsWith(COUNTER_PREFIX + stepExecutionIdentifier)) continue;
            if (metric.getValue() instanceof Long) {
                String key = metric.getName().substring((COUNTER_PREFIX + stepExecutionIdentifier).length() + 1);
                Long newValue = (Long)metric.getValue();
                if (stepExecution.getExecutionContext().containsKey(key)) {
                    Long oldValue = stepExecution.getExecutionContext().getLong(key);
                    newValue = newValue + oldValue;
                    metric = metric.set((Number)newValue);
                }
                stepExecution.getExecutionContext().putLong(key, newValue.longValue());
            }
            metrics.add(metric);
            if (!this.deleteMetricsOnStepFinish) continue;
            this.metricRepository.reset(metric.getName());
        }
        return metrics;
    }

    private List<RichGauge> exportBatchGauges(StepExecution stepExecution) {
        String stepExecutionIdentifier = MDC.get((String)"stepExecutionIdentifier");
        ArrayList<RichGauge> gauges = new ArrayList<RichGauge>();
        for (RichGauge gauge : this.richGaugeRepository.findAll()) {
            if (!gauge.getName().startsWith(GAUGE_PREFIX + stepExecutionIdentifier)) continue;
            stepExecution.getExecutionContext().put(gauge.getName().substring((GAUGE_PREFIX + stepExecutionIdentifier).length() + 1), (Object)gauge);
            gauges.add(gauge);
            if (!this.deleteMetricsOnStepFinish) continue;
            this.richGaugeRepository.reset(gauge.getName());
        }
        return gauges;
    }

    public int getOrder() {
        return 0x7FFFFFFE;
    }

    private static class SimpleMetricsOutputFormatter
    implements MetricsOutputFormatter {
        private SimpleMetricsOutputFormatter() {
        }

        @Override
        public String format(List<RichGauge> gauges, List<Metric<?>> metrics) {
            StringBuilder builder = new StringBuilder("\n########## Metrics Start ##########\n");
            for (RichGauge richGauge : gauges) {
                builder.append(richGauge.toString() + "\n");
            }
            for (Metric metric : metrics) {
                builder.append(metric.toString() + "\n");
            }
            builder.append("########## Metrics End ############");
            return builder.toString();
        }
    }
}

