/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.metrics;

import de.codecentric.batch.metrics.BatchMetrics;
import de.codecentric.batch.metrics.TransactionAwareMetricWriter;
import org.slf4j.MDC;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;

public class BatchMetricsImpl
implements BatchMetrics {
    private MetricWriter metricWriter;
    private MetricWriter transactionAwareMetricWriter;

    public BatchMetricsImpl(MetricWriter metricWriter) {
        this.metricWriter = metricWriter;
        this.transactionAwareMetricWriter = new TransactionAwareMetricWriter(metricWriter);
    }

    @Override
    public void increment(String metricName) {
        this.transactionAwareMetricWriter.increment(new Delta(this.wrapCounter(metricName), (Number)1L));
    }

    @Override
    public void increment(String metricName, Long value) {
        this.transactionAwareMetricWriter.increment(new Delta(this.wrapCounter(metricName), (Number)value));
    }

    @Override
    public void decrement(String metricName) {
        this.transactionAwareMetricWriter.increment(new Delta(this.wrapCounter(metricName), (Number)-1L));
    }

    @Override
    public void decrement(String metricName, Long value) {
        this.transactionAwareMetricWriter.increment(new Delta(this.wrapCounter(metricName), (Number)(-value.longValue())));
    }

    @Override
    public void reset(String metricName) {
        this.transactionAwareMetricWriter.reset(this.wrapCounter(metricName));
    }

    @Override
    public void submit(String metricName, double value) {
        this.transactionAwareMetricWriter.set(new Metric(this.wrapGauge(metricName), (Number)value));
    }

    @Override
    public void incrementNonTransactional(String metricName) {
        this.metricWriter.increment(new Delta(this.wrapCounter(metricName), (Number)1L));
    }

    @Override
    public void incrementNonTransactional(String metricName, Long value) {
        this.metricWriter.increment(new Delta(this.wrapCounter(metricName), (Number)value));
    }

    @Override
    public void decrementNonTransactional(String metricName) {
        this.metricWriter.increment(new Delta(this.wrapCounter(metricName), (Number)-1L));
    }

    @Override
    public void decrementNonTransactional(String metricName, Long value) {
        this.metricWriter.increment(new Delta(this.wrapCounter(metricName), (Number)(-value.longValue())));
    }

    @Override
    public void resetNonTransactional(String metricName) {
        this.metricWriter.reset(this.wrapCounter(metricName));
    }

    @Override
    public void submitNonTransactional(String metricName, double value) {
        this.metricWriter.set(new Metric(this.wrapGauge(metricName), (Number)value));
    }

    private String wrapCounter(String metricName) {
        return "counter.batch." + MDC.get((String)"stepExecutionIdentifier") + "." + metricName;
    }

    private String wrapGauge(String metricName) {
        return "gauge.batch." + MDC.get((String)"stepExecutionIdentifier") + "." + metricName;
    }
}

