/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.metrics;

import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.util.ClassUtils;
import org.springframework.util.StopWatch;

public abstract class AbstractBatchMetricsAspect {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBatchMetricsAspect.class);
    private GaugeService gaugeService;

    public AbstractBatchMetricsAspect(GaugeService gaugeService) {
        this.gaugeService = gaugeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object profileMethod(ProceedingJoinPoint pjp) throws Throwable {
        StopWatch stopWatch = this.startStopWatch();
        try {
            Object object = pjp.proceed();
            return object;
        }
        finally {
            this.gaugeService.submit("gauge.batch." + this.getStepIdentifier() + "." + ClassUtils.getShortName(pjp.getTarget().getClass()) + "." + pjp.getSignature().getName(), (double)this.getTotalTimeMillis(stopWatch));
        }
    }

    private long getTotalTimeMillis(StopWatch stopWatch) {
        stopWatch.stop();
        long duration = stopWatch.getTotalTimeMillis();
        return duration;
    }

    private StopWatch startStopWatch() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        return stopWatch;
    }

    private String getStepIdentifier() {
        String stepIdentifier = MDC.get((String)"stepExecutionIdentifier");
        if (stepIdentifier == null) {
            LOG.warn("Step identifier could not be read from MDC.");
            stepIdentifier = "unknown";
        }
        return stepIdentifier;
    }
}

